/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.usersettings.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Objects;

public abstract class AbstractNotificationSendModePreferenceChangeEvent
extends ApplicationEvent {
    private final ApplicationUser affectedUser;
    private final SendMode defaultSendMode;
    private final SendMode newSendMode;

    protected AbstractNotificationSendModePreferenceChangeEvent(@Nonnull Object source, @Nonnull ApplicationUser affectedUser, @Nonnull SendMode newSendMode, @Nonnull SendMode defaultSendMode) {
        super(source);
        this.affectedUser = Objects.requireNonNull(affectedUser, "affectedUser");
        this.defaultSendMode = Objects.requireNonNull(defaultSendMode, "defaultSendMode");
        this.newSendMode = Objects.requireNonNull(newSendMode, "newSendMode");
    }

    @Nonnull
    public ApplicationUser getAffectedUser() {
        return this.affectedUser;
    }

    @Nonnull
    public SendMode getNewSendMode() {
        return this.newSendMode;
    }

    @Nonnull
    public SendMode getDefaultSendMode() {
        return this.defaultSendMode;
    }

    public boolean getUserIsAffectedUser() {
        return ApplicationUserEquality.equals((ApplicationUser)this.getUser(), (Object)this.affectedUser);
    }

    @EventName
    public String getAnalyticsEventName() {
        return this.getAnalyticsBaseKey() + this.newSendMode.name().toLowerCase(Locale.ROOT);
    }

    protected abstract String getAnalyticsBaseKey();
}

