/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.util;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.content.DiffSegmentType;
import java.util.Map;

public final class AnchorUtils {
    private AnchorUtils() {
        throw new UnsupportedOperationException(AnchorUtils.class.getName() + " should not be instantiated");
    }

    public static void addLocationInfo(CommentThreadDiffAnchor anchor, Map<String, Object> context) {
        if (anchor != null) {
            String filePath = AnchorUtils.getFilePath(anchor);
            String fileName = AnchorUtils.getFileName(anchor);
            context.put("filePath", filePath);
            context.put("fileName", fileName);
            if (anchor.isLineAnchor()) {
                context.put("line", AnchorUtils.getPrefixedLineNumber((DiffSegmentType)anchor.getLineType().get(), anchor.getLine()));
                if (anchor.isMultilineAnchor()) {
                    context.put("startLine", AnchorUtils.getPrefixedLineNumber((DiffSegmentType)anchor.getMultilineStartLineType().get(), (Integer)anchor.getMultilineStartLine().get()));
                }
            }
            context.put("until", anchor.getToHash());
            anchor.getFromHash().ifPresent(fromHash -> context.put("since", fromHash));
        }
    }

    public static String getFilePath(CommentThreadDiffAnchor anchor) {
        String path = anchor.getPath();
        return path.contains("/") ? path.substring(0, path.lastIndexOf(47) + 1) : "";
    }

    public static String getFileName(CommentThreadDiffAnchor anchor) {
        String path = anchor.getPath();
        return path.contains("/") ? path.substring(path.lastIndexOf(47) + 1) : path;
    }

    private static String getPrefixedLineNumber(DiffSegmentType lineType, int line) {
        Object value = "";
        if (lineType == DiffSegmentType.ADDED) {
            value = (String)value + "+" + (String)value;
        } else if (lineType == DiffSegmentType.REMOVED) {
            value = (String)value + "-" + (String)value;
        }
        value = (String)value + String.valueOf(line);
        return value;
    }
}

