/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.util;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BidiUtils {
    private static final Pattern bidiPattern = Pattern.compile("([\\u202A-\\u202E\\u2066-\\u2069\\u200E\\u200F\\u061C])");

    private BidiUtils() {
        throw new UnsupportedOperationException(BidiUtils.class.getName() + " should not be instantiated");
    }

    @Nonnull
    public static String replaceBidi(@Nonnull String text) {
        Objects.requireNonNull(text, "text");
        Matcher matcher = bidiPattern.matcher(text);
        StringBuffer replaced = new StringBuffer();
        while (matcher.find()) {
            String bidiString = matcher.group(1);
            for (char c : bidiString.toCharArray()) {
                matcher.appendReplacement(replaced, String.format("<U+%X>", c));
            }
        }
        matcher.appendTail(replaced);
        return replaced.toString();
    }
}

