/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.web;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestActivitySearchRequest;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestActivityRenderContext;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestActivityRenderer;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.DateUtils;

@AdminOnly
public class NotificationRendererDebugServlet
extends HttpServlet {
    private static final Set<PullRequestAction> ACTIONS_TO_INCLUDE_IN_PR_BATCH_EMAILS = Sets.immutableEnumSet((Enum)PullRequestAction.APPROVED, (Enum[])new PullRequestAction[]{PullRequestAction.REVIEWED, PullRequestAction.UNAPPROVED, PullRequestAction.REOPENED, PullRequestAction.DECLINED, PullRequestAction.UPDATED, PullRequestAction.AUTO_MERGE_CANCELLED, PullRequestAction.AUTO_MERGE_REQUESTED});
    private static final Pattern PR_PATTERN = Pattern.compile("/projects/([^/]+)/repos/([^/]+)/pull-requests/(\\d+)");
    private final AuthenticationContext authenticationContext;
    private final MailService mailService;
    private final PermissionValidationService permissionValidationService;
    private final PullRequestActivityRenderer pullRequestActivityRenderer;
    private final PullRequestService pullRequestService;
    private final RepositoryService repositoryService;
    private final WebSudoManager webSudoManager;

    public NotificationRendererDebugServlet(AuthenticationContext authenticationContext, MailService mailService, PermissionValidationService permissionValidationService, PullRequestActivityRenderer pullRequestActivityRenderer, PullRequestService pullRequestService, RepositoryService repositoryService, WebSudoManager webSudoManager) {
        this.authenticationContext = authenticationContext;
        this.mailService = mailService;
        this.permissionValidationService = permissionValidationService;
        this.pullRequestActivityRenderer = pullRequestActivityRenderer;
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
        this.webSudoManager = webSudoManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        this.webSudoManager.willExecuteWebSudoRequest(req);
        resp.setContentType("text/html;charset=UTF-8");
        Matcher matcher = PR_PATTERN.matcher(req.getPathInfo());
        if (!matcher.matches()) {
            resp.sendError(400);
            return;
        }
        String projectKey = matcher.group(1);
        String repoKey = matcher.group(2);
        int prId = Integer.parseInt(matcher.group(3));
        Date sinceDate = NotificationRendererDebugServlet.parseDate(req.getParameter("since"));
        Repository repo = this.repositoryService.getBySlug(projectKey, repoKey);
        if (repo == null) {
            resp.sendError(404);
            return;
        }
        PullRequest pullRequest = this.pullRequestService.getById(repo.getId(), (long)prId);
        ClassifiedActivities activities = this.getPullRequestActivities(repo, prId, sinceDate);
        PullRequestActivityRenderContext context = new PullRequestActivityRenderContext.Builder(NotificationRendererDebugServlet.getCommentIdsToHighlight(activities), pullRequest, ACTIONS_TO_INCLUDE_IN_PR_BATCH_EMAILS).activities(NotificationRendererDebugServlet.getActivitiesToDisplay(activities)).build();
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        Iterable<MailMessage> messages = this.pullRequestActivityRenderer.render(user, context);
        for (MailMessage mailMessage : messages) {
            resp.getWriter().write(mailMessage.getText());
            if (req.getParameter("send") == null) continue;
            this.mailService.submit(mailMessage);
        }
    }

    private static Iterable<PullRequestActivity> getActivitiesToDisplay(ClassifiedActivities activities) {
        Set relevantRootCommentIds = activities.recentComment.stream().map(activity -> activity.getComment().getThread().getRootComment().getId()).collect(Collectors.toSet());
        Stream<PullRequestCommentActivity> relevantRootCommentActivity = activities.rootComment.stream().filter(activity -> relevantRootCommentIds.contains(activity.getComment().getId()));
        return Stream.concat(activities.recentNonComment.stream(), relevantRootCommentActivity).collect(Collectors.toList());
    }

    private static Set<Long> getCommentIdsToHighlight(ClassifiedActivities activities) {
        return activities.recentComment.stream().map(activity -> activity.getComment().getId()).collect(Collectors.toSet());
    }

    private static Date parseDate(String dateString) {
        if (dateString != null) {
            try {
                return DateUtils.parseDate((String)dateString, (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss"});
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Date(0L);
    }

    private ClassifiedActivities getPullRequestActivities(Repository repo, int prId, Date since) {
        PullRequestActivitySearchRequest searchRequest = new PullRequestActivitySearchRequest.Builder(repo.getId(), (long)prId).build();
        PagedIterable activities = new PagedIterable(request -> this.pullRequestService.searchActivities(searchRequest, request), 100);
        return new ClassifiedActivities((Iterable<PullRequestActivity>)activities, since);
    }

    private static class ClassifiedActivities {
        private final Set<PullRequestCommentActivity> recentComment = Sets.newHashSet();
        private final Set<PullRequestActivity> recentNonComment = Sets.newHashSet();
        private final Set<PullRequestCommentActivity> rootComment = Sets.newHashSet();

        private ClassifiedActivities(Iterable<PullRequestActivity> activities, final Date since) {
            PullRequestActivityVisitor activityVisitor = new PullRequestActivityVisitor(){

                public void visit(@Nonnull PullRequestActivity activity) {
                    PullRequestAction action = activity.getAction();
                    if (action != PullRequestAction.OPENED && action != PullRequestAction.UPDATED) {
                        ClassifiedActivities.addIfRecent(recentNonComment, activity, since);
                    }
                }

                public void visit(@Nonnull PullRequestCommentActivity activity) {
                    ClassifiedActivities.addIfRecent(recentComment, activity, since);
                    if (activity.getCommentAction() == CommentAction.ADDED && activity.getComment().equals((Object)activity.getComment().getThread().getRootComment())) {
                        rootComment.add(activity);
                    }
                }

                public void visit(@Nonnull PullRequestMergeActivity activity) {
                    ClassifiedActivities.addIfRecent(recentNonComment, activity, since);
                }

                public void visit(@Nonnull PullRequestRescopeActivity activity) {
                    ClassifiedActivities.addIfRecent(recentNonComment, activity, since);
                }
            };
            activities.forEach(activity -> activity.accept(activityVisitor));
        }

        private static <T extends PullRequestActivity> void addIfRecent(Set<T> activities, T activity, Date since) {
            if (activity.getCreatedDate().after(since)) {
                activities.add(activity);
            }
        }
    }
}

