/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.web;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsSearchRequest;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsService;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.web.BaseNotificationServlet;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

public class RepositoryNotificationSettingsServlet
extends BaseNotificationServlet {
    private static final int PAGE_SIZE = 25;
    private static final String PLUGIN_KEY = "com.atlassian.bitbucket.server.bitbucket-notification";
    private static final String SETTINGS_RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-notification:repository-notification-settings-serverside";
    private static final String TEMPLATE_KEY = "bitbucketPluginNotification.internal.feature.repositories.settings.repositoryNotificationSettings.repositoryNotificationSettings";
    private final AuthenticationContext authenticationContext;
    private final RepositoryNotificationSettingsService settingsService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public RepositoryNotificationSettingsServlet(AuthenticationContext authenticationContext, LoginUriProvider loginUriProvider, SoyTemplateRenderer soyTemplateRenderer, RepositoryNotificationSettingsService settingsService) {
        super(loginUriProvider);
        this.authenticationContext = authenticationContext;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.settingsService = settingsService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            this.sendRedirectToLogin(req, resp);
            return;
        }
        ImmutableSet pullRequestScopes = ImmutableSet.of((Object)((Object)PullRequestNotificationScope.ALL), (Object)((Object)PullRequestNotificationScope.STATE_CHANGES));
        ImmutableSet pushScopes = ImmutableSet.of((Object)((Object)PushNotificationScope.ALL), (Object)((Object)PushNotificationScope.DEFAULT_BRANCH));
        RepositoryNotificationSettingsSearchRequest request = new RepositoryNotificationSettingsSearchRequest.Builder().pullRequestNotificationScopes((Iterable<PullRequestNotificationScope>)pullRequestScopes).pushNotificationScopes((Iterable<PushNotificationScope>)pushScopes).user(user).build();
        Page<RepositoryNotificationSettings> settings = this.settingsService.search(request, PageUtils.newRequest((int)0, (int)25));
        ImmutableMap params = ImmutableMap.of((Object)"user", (Object)user, (Object)"repositorySettings", settings);
        resp.setContentType("text/html;charset=UTF-8");
        this.soyTemplateRenderer.render((Appendable)resp.getWriter(), SETTINGS_RESOURCE_KEY, TEMPLATE_KEY, (Map)params);
    }
}

