/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.web;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.watcher.IsWatchingRequest;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.stash.internal.notification.NotificationConstants;
import com.atlassian.stash.internal.notification.repository.RepositoryNotificationSettingsService;
import com.atlassian.stash.internal.notification.repository.model.PullRequestNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.PushNotificationScope;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class RepositoryWatchButtonContextProvider
implements ContextProvider {
    private final RepositoryService repositoryService;
    private final RepositoryNotificationSettingsService settingsService;
    private final WatcherService watcherService;

    public RepositoryWatchButtonContextProvider(RepositoryService repositoryService, RepositoryNotificationSettingsService settingsService, WatcherService watcherService) {
        this.repositoryService = repositoryService;
        this.settingsService = settingsService;
        this.watcherService = watcherService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Repository repository = (Repository)context.get("repository");
        ApplicationUser currentUser = (ApplicationUser)context.get("principal");
        if (currentUser == null) {
            return Collections.emptyMap();
        }
        Optional<RepositoryNotificationSettings> settings = this.settingsService.getByRepositoryAndUser(repository, currentUser);
        Map<String, Object> settingsMap = settings.map(s -> this.toSettingsMap(s.getPullRequestNotificationScope(), s.getPushNotificationScope())).orElse(this.toSettingsMap(NotificationConstants.DEFAULT_PULL_REQUEST_NOTIFICATION_SCOPE, NotificationConstants.DEFAULT_PUSH_NOTIFICATION_SCOPE));
        return new ImmutableMap.Builder().put((Object)"settings", settingsMap).put((Object)"isWatching", (Object)this.watcherService.isWatching(new IsWatchingRequest.Builder((Watchable)repository).build())).put((Object)"defaultBranch", (Object)settings.map(RepositoryNotificationSettings::getDefaultBranch).orElseGet(() -> this.repositoryService.getDefaultBranch(repository)).getDisplayId()).build();
    }

    private Map<String, Object> toSettingsMap(PullRequestNotificationScope pullRequestNotificationScope, PushNotificationScope pushNotificationScope) {
        return ImmutableMap.of((Object)"pullRequestNotificationScope", (Object)((Object)pullRequestNotificationScope), (Object)"pushNotificationScope", (Object)((Object)pushNotificationScope));
    }
}

