/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.web;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class UserNotificationSettingsModel {
    private static final String DELAY_KEY = "delay";
    private static final String DID_SWITCH_TO_IMMEDIATE_KEY = "didSwitchToImmediate";
    private static final String ERRORS_KEY = "formErrors";
    private static final String PR_SEND_MODE = "prSendMode";
    private static final String REPO_SEND_MODE = "repoSendMode";
    private static final String SAVED_KEY = "saved";
    private static final String USER_KEY = "user";
    private final long delay;
    private final boolean didSwitchToImmediate;
    private final List<String> formErrors;
    private final SendMode pullRequestSendMode;
    private final SendMode repositorySendMode;
    private final boolean saved;
    private final ApplicationUser user;

    private UserNotificationSettingsModel(Builder builder) {
        this.delay = builder.delay;
        this.didSwitchToImmediate = builder.didSwitchToImmediate;
        this.formErrors = builder.formErrors.build();
        this.pullRequestSendMode = builder.pullRequestSendMode;
        this.repositorySendMode = builder.repositorySendMode;
        this.saved = builder.saved;
        this.user = builder.user;
    }

    @Nonnull
    public Map<String, Object> asData() {
        ImmutableMap.Builder data = new ImmutableMap.Builder();
        data.put((Object)DID_SWITCH_TO_IMMEDIATE_KEY, (Object)this.didSwitchToImmediate);
        data.put((Object)DELAY_KEY, (Object)this.delay);
        data.put((Object)SAVED_KEY, (Object)this.saved);
        data.put((Object)USER_KEY, (Object)this.user);
        if (!this.formErrors.isEmpty()) {
            data.put((Object)ERRORS_KEY, this.formErrors);
        }
        if (this.pullRequestSendMode != null) {
            data.put((Object)PR_SEND_MODE, (Object)this.pullRequestSendMode);
        }
        if (this.repositorySendMode != null) {
            data.put((Object)REPO_SEND_MODE, (Object)this.repositorySendMode);
        }
        return data.build();
    }

    public static class Builder
    extends BuilderSupport {
        private long delay;
        private boolean didSwitchToImmediate;
        private ImmutableList.Builder<String> formErrors = new ImmutableList.Builder();
        private SendMode pullRequestSendMode;
        private SendMode repositorySendMode;
        private boolean saved;
        private ApplicationUser user;

        @Nonnull
        public UserNotificationSettingsModel build() {
            return new UserNotificationSettingsModel(this);
        }

        @Nonnull
        public Builder delay(long value) {
            this.delay = value;
            return this;
        }

        @Nonnull
        public Builder didSwitchToImmediate(boolean value) {
            this.didSwitchToImmediate = value;
            return this;
        }

        @Nonnull
        public Builder formError(@Nonnull String value) {
            Builder.addIf((Predicate)NOT_BLANK, this.formErrors, (Object)value);
            return this;
        }

        @Nonnull
        public Builder formErrors(@Nonnull Iterable<String> values) {
            Builder.addIf((Predicate)NOT_BLANK, this.formErrors, values);
            return this;
        }

        @Nonnull
        public Builder pullRequestSendMode(@Nullable SendMode value) {
            this.pullRequestSendMode = value;
            return this;
        }

        @Nonnull
        public Builder repositorySendMode(@Nullable SendMode value) {
            this.repositorySendMode = value;
            return this;
        }

        @Nonnull
        public Builder saved(boolean value) {
            this.saved = value;
            return this;
        }

        @Nonnull
        public Builder user(@Nonnull ApplicationUser value) {
            this.user = Objects.requireNonNull(value, UserNotificationSettingsModel.USER_KEY);
            return this;
        }
    }
}

