/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.web;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.notification.NotificationConfig;
import com.atlassian.stash.internal.notification.usersettings.EmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettingsService;
import com.atlassian.stash.internal.notification.web.BaseNotificationServlet;
import com.atlassian.stash.internal.notification.web.UserNotificationSettingsModel;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UserNotificationSettingsServlet
extends BaseNotificationServlet {
    private static final String PLUGIN_KEY = "com.atlassian.bitbucket.server.bitbucket-notification";
    private static final String SETTINGS_RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-notification:user-settings-serverside";
    private static final String TEMPLATE_KEY = "bitbucketPluginNotification.internal.feature.usersettings.settings.userSettings";
    private static final String PR_SEND_MODE_FORM_KEY = "pr-notification-send-mode";
    private static final String REPO_SEND_MODE_FORM_KEY = "repo-notification-send-mode";
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final NotificationConfig notificationConfig;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final AuthenticationContext authenticationContext;
    private final UserNotificationSettingsService userNotificationSettingsService;
    private final XsrfTokenValidator xsrfTokenValidator;
    private final XsrfTokenAccessor xsrfTokenAccessor;

    public UserNotificationSettingsServlet(I18nService i18nService, LoginUriProvider loginUriProvider, NavBuilder navBuilder, NotificationConfig notificationConfig, SoyTemplateRenderer soyTemplateRenderer, AuthenticationContext authenticationContext, UserNotificationSettingsService userNotificationSettingsService, XsrfTokenAccessor xsrfTokenAccessor, XsrfTokenValidator xsrfTokenValidator) {
        super(loginUriProvider);
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.notificationConfig = notificationConfig;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.authenticationContext = authenticationContext;
        this.userNotificationSettingsService = userNotificationSettingsService;
        this.xsrfTokenAccessor = xsrfTokenAccessor;
        this.xsrfTokenValidator = xsrfTokenValidator;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            this.sendRedirectToLogin(req, resp);
        } else {
            UserNotificationSettings settings = this.userNotificationSettingsService.getSettingsForUser(user);
            UserNotificationSettingsModel model = new UserNotificationSettingsModel.Builder().delay(this.getMaxBatchDelay()).pullRequestSendMode(UserNotificationSettingsServlet.getPullRequestSendMode(settings)).repositorySendMode(UserNotificationSettingsServlet.getRepositorySendMode(settings)).saved(false).user(user).build();
            this.renderSettingsPage(req, resp, model);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            this.sendRedirectToLogin(req, resp);
        } else if (this.xsrfTokenValidator.validateFormEncodedToken(req)) {
            String prSendModeValue = req.getParameter(PR_SEND_MODE_FORM_KEY);
            String repoSendModeValue = req.getParameter(REPO_SEND_MODE_FORM_KEY);
            UserNotificationSettingsModel.Builder model = new UserNotificationSettingsModel.Builder().delay(this.getMaxBatchDelay()).user(user);
            ArrayList<String> formErrors = new ArrayList<String>();
            if (prSendModeValue == null) {
                formErrors.add(this.i18nService.getMessage("bitbucket.notification.settings.pr.required", new Object[0]));
            }
            if (repoSendModeValue == null) {
                formErrors.add(this.i18nService.getMessage("bitbucket.notification.settings.repo.required", new Object[0]));
            }
            if (formErrors.isEmpty()) {
                SendMode prSendMode = SendMode.fromString(prSendModeValue);
                SendMode repoSendMode = SendMode.fromString(repoSendModeValue);
                UserNotificationSettings existingSettings = this.userNotificationSettingsService.getSettingsForUser(user);
                SendMode existingPrSendMode = UserNotificationSettingsServlet.getPullRequestSendMode(existingSettings);
                SendMode existingRepoSendMode = UserNotificationSettingsServlet.getRepositorySendMode(existingSettings);
                this.userNotificationSettingsService.updateSettingsForUser(user, new UserNotificationSettings.Builder().emailNotificationSettings(new EmailNotificationSettings.Builder().pullRequestSendSettings(new SendSettings.Builder().sendMode(prSendMode).build()).repositorySendSettings(new SendSettings.Builder().sendMode(repoSendMode).build()).build()).build());
                model = new UserNotificationSettingsModel.Builder().delay(this.getMaxBatchDelay()).pullRequestSendMode(prSendMode).repositorySendMode(repoSendMode).saved(true).user(user);
                if (SendMode.BATCHED.equals((Object)existingPrSendMode) && prSendMode.equals((Object)SendMode.IMMEDIATE) || SendMode.BATCHED.equals((Object)existingRepoSendMode) && repoSendMode.equals((Object)SendMode.IMMEDIATE)) {
                    model.didSwitchToImmediate(true);
                }
            } else {
                model.formErrors(formErrors);
            }
            this.renderSettingsPage(req, resp, model.build());
        } else {
            req.getRequestDispatcher(this.navBuilder.xsrfNotification().buildRelNoContext()).forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private static SendMode getPullRequestSendMode(UserNotificationSettings settings) {
        return settings.getEmailNotificationSettings().flatMap(EmailNotificationSettings::getPullRequestSendModeSettings).map(SendSettings::getSendMode).orElse(null);
    }

    private static SendMode getRepositorySendMode(UserNotificationSettings settings) {
        return settings.getEmailNotificationSettings().flatMap(EmailNotificationSettings::getRepositorySendModeSettings).map(SendSettings::getSendMode).orElse(null);
    }

    private void renderSettingsPage(HttpServletRequest req, HttpServletResponse resp, UserNotificationSettingsModel model) throws IOException, ServletException {
        resp.setContentType("text/html;charset=UTF-8");
        resp.setHeader("X-Frame-Options", "SAMEORIGIN");
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), SETTINGS_RESOURCE_KEY, TEMPLATE_KEY, model.asData(), this.getInjectedData(req, resp));
        }
        catch (SoyException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Map<String, Object> getInjectedData(HttpServletRequest req, HttpServletResponse resp) {
        HashMap<String, Object> injectedData = new HashMap<String, Object>();
        injectedData.put("xsrfTokenName", this.xsrfTokenValidator.getXsrfParameterName());
        injectedData.put("xsrfTokenValue", this.xsrfTokenAccessor.getXsrfToken(req, resp, true));
        injectedData.put("principal", this.authenticationContext.getCurrentUser());
        return injectedData;
    }

    private long getMaxBatchDelay() {
        return this.notificationConfig.getBatchMaxWaitMinutes();
    }
}

