/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.plugin.remote.event.listener;

import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.plugin.remote.event.listener.AbstractEventProducer;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.RemoteEventProducerRegistrar;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.stash.plugin.remote.event.StashBranchChangedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashBranchCreatedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashBranchDeletedRemoteEvent;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@AsynchronousPreferred
public class BitbucketBranchChangedEventProducer
extends AbstractEventProducer {
    private static final Logger log = LoggerFactory.getLogger(BitbucketBranchChangedEventProducer.class);

    @Inject
    public BitbucketBranchChangedEventProducer(@ComponentImport EventPublisher eventPublisher, @ComponentImport RemoteEventProducerRegistrar remoteEventProducerRegistrar) {
        super(eventPublisher, remoteEventProducerRegistrar);
    }

    public Iterable<Class<? extends RemoteEvent>> produces() {
        return ImmutableSet.of(StashBranchChangedRemoteEvent.class, StashBranchCreatedRemoteEvent.class, StashBranchDeletedRemoteEvent.class);
    }

    @EventListener
    public void onRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        Repository repository = event.getRepository();
        String projectKey = repository.getProject().getKey();
        String repositorySlug = repository.getSlug();
        String committer = event.getUser() != null ? event.getUser().getSlug() : null;
        for (RefChange refChange : event.getRefChanges()) {
            MinimalRef ref = refChange.getRef();
            if (!StandardRefType.BRANCH.equals((Object)ref.getType())) continue;
            String branch = ref.getDisplayId();
            log.trace("onRepositoryRefsChanged() projectKey={}; repositorySlug={}; type={}; branch={}; committer={};", new Object[]{projectKey, repositorySlug, refChange.getType(), branch, committer});
            switch (refChange.getType()) {
                case ADD: {
                    this.eventPublisher.publish((Object)new StashBranchCreatedRemoteEvent(projectKey, repositorySlug, branch, committer));
                    break;
                }
                case DELETE: {
                    this.eventPublisher.publish((Object)new StashBranchDeletedRemoteEvent(projectKey, repositorySlug, branch, committer));
                    break;
                }
                case UPDATE: {
                    this.eventPublisher.publish((Object)new StashBranchChangedRemoteEvent(projectKey, repositorySlug, branch, committer));
                }
            }
        }
    }
}

