/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.plugin.remote.event.listener;

import com.atlassian.bitbucket.event.mirror.RepositoryMirrorSynchronizationFailedEvent;
import com.atlassian.bitbucket.event.mirror.RepositoryMirrorSynchronizedEvent;
import com.atlassian.bitbucket.plugin.remote.event.listener.AbstractEventProducer;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.RemoteEventProducerRegistrar;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.stash.plugin.remote.event.BitbucketRepositoryMirrorSynchronizationFailedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.BitbucketRepositoryMirrorSynchronizedRemoteEvent;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@AsynchronousPreferred
public class BitbucketMirrorEventProducer
extends AbstractEventProducer {
    private static final Logger log = LoggerFactory.getLogger(BitbucketMirrorEventProducer.class);

    @Inject
    public BitbucketMirrorEventProducer(@ComponentImport EventPublisher eventPublisher, @ComponentImport RemoteEventProducerRegistrar remoteEventProducerRegistrar) {
        super(eventPublisher, remoteEventProducerRegistrar);
    }

    @EventListener
    public void onRepositoryMirrorSynchronizationFailed(RepositoryMirrorSynchronizationFailedEvent event) {
        Objects.requireNonNull(event, "event");
        String mirrorId = Objects.requireNonNull(event.getMirrorServerId(), "mirrorServerId");
        Repository repository = Objects.requireNonNull(event.getRepository(), "repository");
        Project project = Objects.requireNonNull(repository.getProject(), "project");
        int repositoryId = repository.getId();
        String repositorySlug = repository.getSlug();
        String projectKey = project.getKey();
        log.trace("onRepositoryMirrorSynchronizationFailed() repositoryId={}; mirrorId={};", (Object)repositoryId, (Object)mirrorId);
        this.eventPublisher.publish((Object)new BitbucketRepositoryMirrorSynchronizationFailedRemoteEvent(mirrorId, repositoryId, projectKey, repositorySlug));
    }

    @EventListener
    public void onRepositoryMirrorSynchronized(RepositoryMirrorSynchronizedEvent event) {
        Objects.requireNonNull(event, "event");
        Objects.requireNonNull(event.getFailedRefs(), "failedRefs");
        Objects.requireNonNull(event.getRefChanges(), "refChanges");
        String mirrorId = Objects.requireNonNull(event.getMirrorServerId(), "mirrorServerId");
        Repository repository = Objects.requireNonNull(event.getRepository(), "repository");
        Project project = Objects.requireNonNull(repository.getProject(), "project");
        int repositoryId = repository.getId();
        String repositorySlug = repository.getSlug();
        String projectKey = project.getKey();
        if (!event.getRefChanges().isEmpty() || !event.getFailedRefs().isEmpty()) {
            List refChanges = (List)event.getRefChanges().stream().map(this::mapRefChange).collect(MoreCollectors.toImmutableList());
            Set failedRefs = (Set)event.getFailedRefs().stream().map(MinimalRef::getId).collect(MoreCollectors.toImmutableSet());
            log.trace("onRepositoryMirrorSynchronized() repositoryId={}; mirrorId={}; refChanges={}, #failedRef={};", new Object[]{repositoryId, mirrorId, refChanges, failedRefs});
            this.eventPublisher.publish((Object)new BitbucketRepositoryMirrorSynchronizedRemoteEvent(mirrorId, repositoryId, projectKey, repositorySlug, failedRefs, refChanges));
        }
    }

    public Iterable<Class<? extends RemoteEvent>> produces() {
        return ImmutableSet.of(BitbucketRepositoryMirrorSynchronizedRemoteEvent.class, BitbucketRepositoryMirrorSynchronizationFailedRemoteEvent.class);
    }

    private BitbucketRepositoryMirrorSynchronizedRemoteEvent.RefChange mapRefChange(RefChange refChange) {
        return new BitbucketRepositoryMirrorSynchronizedRemoteEvent.RefChange(refChange.getFromHash(), refChange.getToHash(), refChange.getRef().getId(), BitbucketRepositoryMirrorSynchronizedRemoteEvent.RefChangeType.valueOf(refChange.getType().name()));
    }
}

