/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.plugin.remote.event.listener;

import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReopenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.plugin.remote.event.listener.AbstractEventProducer;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.RemoteEventProducerRegistrar;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.stash.plugin.remote.event.AbstractStashPullRequestRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashCrossRepositoryPullRequestRescopedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestDeclinedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestDeletedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestMergedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestOpenedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestReopenedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestRescopedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestUpdatedRemoteEvent;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class BitbucketPullRequestEventProducer
extends AbstractEventProducer {
    private static final Logger log = LoggerFactory.getLogger(BitbucketPullRequestEventProducer.class);

    @Inject
    public BitbucketPullRequestEventProducer(@ComponentImport EventPublisher eventPublisher, @ComponentImport RemoteEventProducerRegistrar remoteEventProducerRegistrar) {
        super(eventPublisher, remoteEventProducerRegistrar);
    }

    public Iterable<Class<? extends RemoteEvent>> produces() {
        return ImmutableSet.of(StashPullRequestOpenedRemoteEvent.class, StashPullRequestMergedRemoteEvent.class, StashPullRequestReopenedRemoteEvent.class, StashPullRequestDeclinedRemoteEvent.class, StashPullRequestDeletedRemoteEvent.class, StashPullRequestUpdatedRemoteEvent.class, (Object[])new Class[]{StashPullRequestRescopedRemoteEvent.class, StashCrossRepositoryPullRequestRescopedRemoteEvent.class});
    }

    @EventListener
    public void onPullRequestOpened(PullRequestOpenedEvent event) {
        this.populateAndPublish(new StashPullRequestOpenedRemoteEvent.Builder(), (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestMerged(PullRequestMergedEvent event) {
        this.populateAndPublish(new StashPullRequestMergedRemoteEvent.Builder(), (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestReopened(PullRequestReopenedEvent event) {
        this.populateAndPublish(new StashPullRequestReopenedRemoteEvent.Builder(), (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestDeclined(PullRequestDeclinedEvent event) {
        this.populateAndPublish(new StashPullRequestDeclinedRemoteEvent.Builder(), (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestDeleted(PullRequestDeletedEvent event) {
        this.populateAndPublish(new StashPullRequestDeletedRemoteEvent.Builder(), (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestUpdated(PullRequestUpdatedEvent event) {
        this.populateAndPublish(new StashPullRequestUpdatedRemoteEvent.Builder(), (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestRescoped(PullRequestRescopedEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        Repository fromRefRepository = pullRequest.getFromRef().getRepository();
        String fromProjectKey = fromRefRepository.getProject().getKey();
        String fromRepositorySlug = fromRefRepository.getSlug();
        long pullRequestId = pullRequest.getId();
        String committer = pullRequest.getAuthor().getUser().getSlug();
        if (pullRequest.isCrossRepository()) {
            this.eventPublisher.publish((Object)new StashCrossRepositoryPullRequestRescopedRemoteEvent(fromProjectKey, fromRepositorySlug, pullRequestId, committer));
        }
    }

    private void populateAndPublish(AbstractStashPullRequestRemoteEvent.AbstractBuilder<?, ?> builder, PullRequestEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        Repository fromRepository = pullRequest.getFromRef().getRepository();
        Repository toRepository = pullRequest.getToRef().getRepository();
        ((AbstractStashPullRequestRemoteEvent.AbstractBuilder)((AbstractStashPullRequestRemoteEvent.AbstractBuilder)((AbstractStashPullRequestRemoteEvent.AbstractBuilder)((AbstractStashPullRequestRemoteEvent.AbstractBuilder)((AbstractStashPullRequestRemoteEvent.AbstractBuilder)((AbstractStashPullRequestRemoteEvent.AbstractBuilder)builder.id(pullRequest.getId())).fromProjectKey(fromRepository.getProject().getKey())).fromRepositorySlug(fromRepository.getSlug())).fromBranch(pullRequest.getFromRef().getId())).toProjectKey(toRepository.getProject().getKey())).toRepositorySlug(toRepository.getSlug())).toBranch(pullRequest.getToRef().getId());
        this.eventPublisher.publish(builder.build());
    }
}

