/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.HashUtils;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.openpgp.PGPDefaultSignatureGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;

public class PGPSignature
extends PGPDefaultSignatureGenerator {
    public static final int BINARY_DOCUMENT = 0;
    public static final int CANONICAL_TEXT_DOCUMENT = 1;
    public static final int STAND_ALONE = 2;
    public static final int DEFAULT_CERTIFICATION = 16;
    public static final int NO_CERTIFICATION = 17;
    public static final int CASUAL_CERTIFICATION = 18;
    public static final int POSITIVE_CERTIFICATION = 19;
    public static final int SUBKEY_BINDING = 24;
    public static final int PRIMARYKEY_BINDING = 25;
    public static final int DIRECT_KEY = 31;
    public static final int KEY_REVOCATION = 32;
    public static final int SUBKEY_REVOCATION = 40;
    public static final int CERTIFICATION_REVOCATION = 48;
    public static final int TIMESTAMP = 64;
    public static final int THIRD_PARTY_CONFIRMATION = 80;
    final SignaturePacket sigPck;
    private final TrustPacket trustPck;
    private volatile PGPContentVerifier verifier;

    private static SignaturePacket cast(Packet packet) throws IOException {
        if (!(packet instanceof SignaturePacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (SignaturePacket)packet;
    }

    public PGPSignature(BCPGInputStream pIn) throws IOException, PGPException {
        this(PGPSignature.cast(pIn.readPacket()));
    }

    PGPSignature(PGPSignature signature) {
        super(signature.getVersion());
        this.sigPck = signature.sigPck;
        this.sigType = signature.sigType;
        this.trustPck = signature.trustPck;
    }

    PGPSignature(SignaturePacket sigPacket) {
        this(sigPacket, null);
    }

    PGPSignature(SignaturePacket sigPacket, TrustPacket trustPacket) {
        super(sigPacket.getVersion());
        this.sigPck = sigPacket;
        this.sigType = this.sigPck.getSignatureType();
        this.trustPck = trustPacket;
    }

    public int getVersion() {
        return this.sigPck.getVersion();
    }

    public int getKeyAlgorithm() {
        return this.sigPck.getKeyAlgorithm();
    }

    public int getHashAlgorithm() {
        return this.sigPck.getHashAlgorithm();
    }

    public byte[] getDigestPrefix() {
        return this.sigPck.getFingerPrint();
    }

    public boolean isCertification() {
        return PGPSignature.isCertification(this.getSignatureType());
    }

    public void init(PGPContentVerifierBuilderProvider verifierBuilderProvider, PGPPublicKey pubKey) throws PGPException {
        if (this.sigType == 255) {
            throw new PGPException("Illegal signature type 0xFF provided.");
        }
        if (this.getVersion() == 6 && pubKey.getVersion() != 6) {
            throw new PGPException("MUST NOT verify v6 signature with non-v6 key.");
        }
        if (this.getVersion() == 4 && pubKey.getVersion() != 4) {
            throw new PGPException("MUST NOT verify v4 signature with non-v4 key.");
        }
        PGPContentVerifierBuilder verifierBuilder = this.createVerifierProvider(verifierBuilderProvider);
        this.init(verifierBuilder.build(pubKey));
    }

    PGPContentVerifierBuilder createVerifierProvider(PGPContentVerifierBuilderProvider verifierBuilderProvider) throws PGPException {
        return verifierBuilderProvider.get(this.sigPck.getKeyAlgorithm(), this.sigPck.getHashAlgorithm());
    }

    void init(PGPContentVerifier verifier) throws PGPException {
        this.verifier = verifier;
        this.lastb = 0;
        this.sigOut = verifier.getOutputStream();
        this.checkSaltSize();
        this.updateWithSalt();
    }

    private void checkSaltSize() throws PGPException {
        if (this.getVersion() != 6) {
            return;
        }
        int expectedSaltSize = HashUtils.getV6SignatureSaltSizeInBytes(this.getHashAlgorithm());
        if (expectedSaltSize != this.sigPck.getSalt().length) {
            throw new PGPException("RFC9580 defines the salt size for " + PGPUtil.getDigestName(this.getHashAlgorithm()) + " as " + expectedSaltSize + " octets, but signature has " + this.sigPck.getSalt().length + " octets.");
        }
    }

    private void updateWithSalt() throws PGPException {
        if (this.getVersion() == 6) {
            try {
                this.sigOut.write(this.sigPck.getSalt());
            }
            catch (IOException e) {
                throw new PGPException("Could not update with salt.", e);
            }
        }
    }

    public boolean verify() throws PGPException {
        try {
            this.sigOut.write(this.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException e) {
            throw new PGPException(e.getMessage(), e);
        }
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(PGPUserAttributeSubpacketVector userAttributes, PGPPublicKey key) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (!PGPSignature.isCertification(this.sigType) && 48 != this.sigType) {
            throw new PGPException("signature is neither a certification signature nor a certification revocation.");
        }
        return this.doVerifyCertification(userAttributes, key);
    }

    boolean doVerifyCertification(PGPUserAttributeSubpacketVector userAttributes, PGPPublicKey key) throws PGPException {
        this.updateWithPublicKey(key);
        this.getAttributesHash(userAttributes);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(String id, PGPPublicKey key) throws PGPException {
        return this.verifyCertification(Strings.toUTF8ByteArray((String)id), key);
    }

    public boolean verifyCertification(byte[] rawID, PGPPublicKey key) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (!PGPSignature.isCertification(this.sigType) && 48 != this.sigType) {
            throw new PGPException("signature is neither a certification signature nor a certification revocation.");
        }
        return this.doVerifyCertification(rawID, key);
    }

    boolean doVerifyCertification(byte[] rawID, PGPPublicKey key) throws PGPException {
        this.updateWithPublicKey(key);
        this.updateWithIdData(180, rawID);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(PGPPublicKey masterKey, PGPPublicKey pubKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (24 != this.sigType && 25 != this.sigType && 40 != this.sigType) {
            throw new PGPException("signature is not a key binding signature.");
        }
        return this.doVerifyCertification(masterKey, pubKey);
    }

    boolean doVerifyCertification(PGPPublicKey masterKey, PGPPublicKey pubKey) throws PGPException {
        this.updateWithPublicKey(masterKey);
        this.updateWithPublicKey(pubKey);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    private void addTrailer() {
        try {
            this.sigOut.write(this.sigPck.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException(e.getMessage(), e);
        }
    }

    public boolean verifyCertification(PGPPublicKey pubKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (this.getSignatureType() != 32 && this.getSignatureType() != 31) {
            throw new PGPException("signature is not a key signature");
        }
        return this.doVerifyCertification(pubKey);
    }

    boolean doVerifyCertification(PGPPublicKey pubKey) throws PGPException {
        this.updateWithPublicKey(pubKey);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public int getSignatureType() {
        return this.sigPck.getSignatureType();
    }

    public long getKeyID() {
        return this.sigPck.getKeyID();
    }

    public List<KeyIdentifier> getKeyIdentifiers() {
        ArrayList<KeyIdentifier> identifiers = new ArrayList<KeyIdentifier>();
        if (this.getVersion() <= 3) {
            identifiers.add(new KeyIdentifier(this.getKeyID()));
        } else {
            identifiers.addAll(this.getHashedKeyIdentifiers());
            identifiers.addAll(this.getUnhashedKeyIdentifiers());
        }
        return identifiers;
    }

    public boolean hasKeyIdentifier(KeyIdentifier identifier) {
        Iterator<KeyIdentifier> it = this.getKeyIdentifiers().iterator();
        while (it.hasNext()) {
            if (!it.next().matchesExplicit(identifier)) continue;
            return true;
        }
        return false;
    }

    public List<KeyIdentifier> getHashedKeyIdentifiers() {
        return this.extractKeyIdentifiers(this.sigPck.getHashedSubPackets());
    }

    public List<KeyIdentifier> getUnhashedKeyIdentifiers() {
        return this.extractKeyIdentifiers(this.sigPck.getUnhashedSubPackets());
    }

    private List<KeyIdentifier> extractKeyIdentifiers(SignatureSubpacket[] subpackets) {
        ArrayList<KeyIdentifier> identifiers = new ArrayList<KeyIdentifier>();
        for (int idx = 0; idx != subpackets.length; ++idx) {
            SignatureSubpacket issuer;
            SignatureSubpacket s = subpackets[idx];
            if (s instanceof IssuerFingerprint) {
                issuer = (IssuerFingerprint)s;
                identifiers.add(new KeyIdentifier(((IssuerFingerprint)issuer).getFingerprint()));
            }
            if (!(s instanceof IssuerKeyID)) continue;
            issuer = (IssuerKeyID)s;
            identifiers.add(new KeyIdentifier(((IssuerKeyID)issuer).getKeyID()));
        }
        return identifiers;
    }

    public Date getCreationTime() {
        return new Date(this.sigPck.getCreationTime());
    }

    public byte[] getSignatureTrailer() {
        return this.sigPck.getSignatureTrailer();
    }

    public boolean hasSubpackets() {
        return this.sigPck.getHashedSubPackets() != null || this.sigPck.getUnhashedSubPackets() != null;
    }

    public PGPSignatureSubpacketVector getHashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getHashedSubPackets());
    }

    public PGPSignatureSubpacketVector getUnhashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getUnhashedSubPackets());
    }

    private PGPSignatureSubpacketVector createSubpacketVector(SignatureSubpacket[] pcks) {
        if (pcks != null) {
            return new PGPSignatureSubpacketVector(pcks);
        }
        return null;
    }

    byte[] getSalt() {
        return this.sigPck.getSalt();
    }

    public byte[] getSignature() throws PGPException {
        byte[] signature;
        MPInteger[] sigValues = this.sigPck.getSignature();
        if (sigValues != null) {
            if (sigValues.length == 1) {
                signature = BigIntegers.asUnsignedByteArray((BigInteger)sigValues[0].getValue());
            } else if (this.getKeyAlgorithm() == 22) {
                byte[] b;
                byte[] a = BigIntegers.asUnsignedByteArray((BigInteger)sigValues[0].getValue());
                if (a.length + (b = BigIntegers.asUnsignedByteArray((BigInteger)sigValues[1].getValue())).length > 64) {
                    if (a.length > 57 || b.length > 114) {
                        throw new PGPException("Malformed Ed448 signature encoding (too long).");
                    }
                    signature = new byte[114];
                    System.arraycopy(a, 0, signature, 57 - a.length, a.length);
                    System.arraycopy(b, 0, signature, 114 - b.length, b.length);
                } else {
                    if (a.length > 32 || b.length > 64) {
                        throw new PGPException("Malformed Ed25519 signature encoding (too long).");
                    }
                    signature = new byte[64];
                    System.arraycopy(a, 0, signature, 32 - a.length, a.length);
                    System.arraycopy(b, 0, signature, 64 - b.length, b.length);
                }
            } else {
                try {
                    ASN1EncodableVector v = new ASN1EncodableVector();
                    v.add((ASN1Encodable)new ASN1Integer(sigValues[0].getValue()));
                    v.add((ASN1Encodable)new ASN1Integer(sigValues[1].getValue()));
                    signature = new DERSequence(v).getEncoded();
                }
                catch (IOException e) {
                    throw new PGPException("exception encoding DSA sig.", e);
                }
            }
        } else {
            signature = this.sigPck.getSignatureBytes();
        }
        return signature;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public byte[] getEncoded(boolean forTransfer) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut, forTransfer);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        this.encode(outStream, false);
    }

    public void encode(OutputStream outStream, boolean forTransfer) throws IOException {
        if (!(!forTransfer || this.getHashedSubPackets().isExportable() && this.getUnhashedSubPackets().isExportable())) {
            return;
        }
        BCPGOutputStream out = BCPGOutputStream.wrap(outStream);
        out.writePacket(this.sigPck);
        if (!forTransfer && this.trustPck != null) {
            out.writePacket(this.trustPck);
        }
    }

    public static boolean isCertification(int signatureType) {
        return 16 == signatureType || 17 == signatureType || 18 == signatureType || 19 == signatureType;
    }

    public static boolean isRevocation(int signatureType) {
        return 32 == signatureType || 48 == signatureType || 40 == signatureType;
    }

    public boolean isHardRevocation() {
        RevocationReason reason;
        if (!PGPSignature.isRevocation(this.getSignatureType())) {
            return false;
        }
        if (!this.hasSubpackets()) {
            return true;
        }
        RevocationReason revocationReason = reason = this.getHashedSubPackets() != null ? this.getHashedSubPackets().getRevocationReason() : null;
        if (reason == null) {
            return true;
        }
        byte code = reason.getRevocationReason();
        if (code >= 100 && code <= 110) {
            return true;
        }
        return code != 1 && code != 3 && code != 32;
    }

    public static boolean isSignatureEncodingEqual(PGPSignature sig1, PGPSignature sig2) {
        return Arrays.areEqual((byte[])sig1.sigPck.getSignatureBytes(), (byte[])sig2.sigPck.getSignatureBytes());
    }

    public static PGPSignature join(PGPSignature sig1, PGPSignature sig2) throws PGPException {
        if (sig1.getVersion() < 4) {
            return sig1;
        }
        if (sig1.getVersion() != sig2.getVersion() || !PGPSignature.isSignatureEncodingEqual(sig1, sig2)) {
            throw new IllegalArgumentException("These are different signatures.");
        }
        SignatureSubpacket[] sig1Unhashed = sig1.getUnhashedSubPackets().packets;
        SignatureSubpacket[] sig2Unhashed = sig2.getUnhashedSubPackets().packets;
        ArrayList<SignatureSubpacket> merged = new ArrayList<SignatureSubpacket>(java.util.Arrays.asList(sig1Unhashed));
        for (int i = 0; i != sig2Unhashed.length; ++i) {
            SignatureSubpacket subpacket = sig2Unhashed[i];
            boolean found = false;
            for (int j = 0; j != sig1Unhashed.length; ++j) {
                SignatureSubpacket existing = sig1Unhashed[j];
                if (!subpacket.equals(existing)) continue;
                found = true;
                break;
            }
            if (found) continue;
            merged.add(subpacket);
        }
        SignatureSubpacket[] unhashed = merged.toArray(new SignatureSubpacket[0]);
        return new PGPSignature(SignaturePacket.copyOfWith(sig1.sigPck, unhashed));
    }
}

