/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.util.Arrays;

public class BcPBEDataDecryptorFactory
extends PBEDataDecryptorFactory {
    public BcPBEDataDecryptorFactory(char[] pass, PGPDigestCalculatorProvider calculatorProvider) {
        super(pass, calculatorProvider);
    }

    @Override
    public byte[] recoverSessionData(int keyAlgorithm, byte[] key, byte[] secKeyData) throws PGPException {
        try {
            if (secKeyData != null && secKeyData.length > 0) {
                BlockCipher engine = BcImplProvider.createBlockCipher(keyAlgorithm);
                return BcUtil.processBufferedBlockCipher(false, engine, key, new byte[engine.getBlockSize()], secKeyData, 0, secKeyData.length);
            }
            byte[] keyBytes = new byte[key.length + 1];
            keyBytes[0] = (byte)keyAlgorithm;
            System.arraycopy(key, 0, keyBytes, 1, key.length);
            return keyBytes;
        }
        catch (Exception e) {
            throw new PGPException("Exception recovering session info", e);
        }
    }

    @Override
    public byte[] recoverAEADEncryptedSessionData(SymmetricKeyEncSessionPacket keyData, byte[] ikm) throws PGPException {
        byte[] kek;
        if (keyData.getVersion() < 5) {
            throw new PGPException("SKESK packet MUST be version 5 or later.");
        }
        byte[] hkdfInfo = keyData.getAAData();
        if (keyData.getVersion() == 5) {
            kek = ikm;
        } else if (keyData.getVersion() == 6) {
            int kekLen = SymmetricKeyUtils.getKeyLengthInOctets(keyData.getEncAlgorithm());
            kek = BcAEADUtil.generateHKDFBytes(ikm, null, hkdfInfo, kekLen);
        } else {
            throw new UnsupportedPacketVersionException("Unsupported SKESK packet version encountered: " + keyData.getVersion());
        }
        byte[] data = Arrays.concatenate((byte[])keyData.getSecKeyData(), (byte[])keyData.getAuthTag());
        return BcAEADUtil.processAEADData(false, keyData.getEncAlgorithm(), keyData.getAeadAlgorithm(), kek, keyData.getIv(), keyData.getAAData(), data, 0, data.length, "Exception recovering session info");
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
        BlockCipher engine = BcImplProvider.createBlockCipher(encAlgorithm);
        return BcUtil.createDataDecryptor(withIntegrityPacket, engine, key);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aeadEncDataPacket, PGPSessionKey sessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aeadEncDataPacket, sessionKey);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket seipd, PGPSessionKey sessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(seipd, sessionKey);
    }
}

