/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.api;

import com.atlassian.annotations.ExperimentalApi;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;

@ExperimentalApi
public class Entity<K, T> {
    private final K id;
    private final long timestamp;
    private final T value;

    private Entity(K id, long timestamp, T value) {
        this.id = id;
        this.timestamp = timestamp;
        this.value = value;
    }

    public static <K, T> Entity<K, T> getInstance(K id, @Nonnull Instant timestamp, @Nonnull T value) {
        Objects.requireNonNull(timestamp);
        Objects.requireNonNull(value);
        return new Entity<K, T>(id, timestamp.getEpochSecond(), value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.timestamp == entity.timestamp && Objects.equals(this.id, entity.id) && Objects.equals(this.value, entity.value);
    }

    public K getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.timestamp, this.value);
    }
}

