/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.api;

import com.atlassian.annotations.ExperimentalApi;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@ExperimentalApi
public class LogRecord<K> {
    private final K id;
    private final long lastModified;
    private final Map<String, Object> payload;

    private LogRecord(K id, long lastModified, Map<String, Object> payload) {
        this.id = id;
        this.lastModified = lastModified;
        this.payload = payload;
    }

    public static <K> LogRecord<K> getInstance(K id, long lastModified, @Nonnull Map<String, Object> payload) {
        Objects.requireNonNull(payload);
        return new LogRecord<K>(id, lastModified, payload);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogRecord logRecord = (LogRecord)o;
        return this.lastModified == logRecord.lastModified && Objects.equals(this.id, logRecord.id) && Objects.equals(this.payload, logRecord.payload);
    }

    public K getId() {
        return this.id;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.lastModified, this.payload);
    }
}

