/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.api.extract;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.business.insights.api.filter.OptOutEntityIdentifier;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@ExperimentalApi
public class EntityStreamerQuery {
    private final Instant from;
    private final List<OptOutEntityIdentifier> optOutEntityIdentifiers;

    private EntityStreamerQuery(Builder builder) {
        this.from = Objects.requireNonNull(builder.from);
        this.optOutEntityIdentifiers = Objects.requireNonNull(builder.optOutEntityIdentifiers);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public Instant getFrom() {
        return this.from;
    }

    @Nonnull
    public List<OptOutEntityIdentifier> getOptOutEntityIdentifiers() {
        return this.optOutEntityIdentifiers;
    }

    public static class Builder {
        private Instant from;
        private List<OptOutEntityIdentifier> optOutEntityIdentifiers = new ArrayList<OptOutEntityIdentifier>();

        private Builder() {
        }

        public EntityStreamerQuery build() {
            return new EntityStreamerQuery(this);
        }

        public Builder from(Instant from) {
            this.from = from;
            return this;
        }

        public Builder optOutEntityIdentifier(OptOutEntityIdentifier optOutEntityIdentifier) {
            this.optOutEntityIdentifiers.add(optOutEntityIdentifier);
            return this;
        }

        public Builder optOutEntityIdentifiers(List<OptOutEntityIdentifier> optOutEntityIdentifiers) {
            this.optOutEntityIdentifiers.addAll(optOutEntityIdentifiers);
            return this;
        }
    }
}

