/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.api.extract;

import com.atlassian.annotations.ExperimentalApi;
import java.util.Objects;
import javax.annotation.Nonnull;

@ExperimentalApi
public class StreamerValidationResult {
    private static final StreamerValidationResult OK_RESULT = new StreamerValidationResult(Action.OK, "");
    private final Action action;
    private final String detailMessage;

    private StreamerValidationResult(@Nonnull Action action, @Nonnull String detailMessage) {
        this.action = Objects.requireNonNull(action);
        this.detailMessage = Objects.requireNonNull(detailMessage);
    }

    @Nonnull
    public String getDetailMessage() {
        return this.detailMessage;
    }

    @Nonnull
    public Action getAction() {
        return this.action;
    }

    @Nonnull
    public static StreamerValidationResult pass() {
        return OK_RESULT;
    }

    @Nonnull
    public static StreamerValidationResult warn(@Nonnull String detailMessage) {
        return new StreamerValidationResult(Action.OK, detailMessage);
    }

    @Nonnull
    public static StreamerValidationResult fail(@Nonnull String detailMessage) {
        return new StreamerValidationResult(Action.ABORT, detailMessage);
    }

    public static enum Action {
        OK,
        ABORT;

    }
}

