/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.api.filter;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.business.insights.api.filter.OptOutEntityIdentifier;
import com.atlassian.business.insights.api.filter.OptOutEntityType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ExperimentalApi
public class OptOutEntity {
    private final OptOutEntityIdentifier identifier;
    private final String displayName;
    private final String key;
    private final String uri;

    private OptOutEntity(Builder builder) {
        this.identifier = builder.identifier;
        this.displayName = builder.displayName;
        this.key = builder.key;
        this.uri = builder.uri;
    }

    public static Builder builder(@Nonnull OptOutEntity src) {
        Objects.requireNonNull(src);
        return new Builder(src.identifier).displayName(src.displayName).uri(src.uri);
    }

    public static Builder builder(@Nonnull OptOutEntityIdentifier identifier) {
        return new Builder(identifier);
    }

    public static Builder builder(@Nonnull OptOutEntityType type, @Nonnull String identifier) {
        return new Builder(new OptOutEntityIdentifier(type, identifier));
    }

    @Nonnull
    public OptOutEntityIdentifier getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptOutEntity)) {
            return false;
        }
        OptOutEntity optOutEntity = (OptOutEntity)o;
        return this.identifier.equals(optOutEntity.identifier) && Objects.equals(this.key, optOutEntity.key) && Objects.equals(this.displayName, optOutEntity.displayName) && Objects.equals(this.uri, optOutEntity.uri);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.displayName, this.key, this.uri);
    }

    public String toString() {
        return "OptOutEntity{identifier=" + String.valueOf(this.identifier) + ", key='" + this.key + "', displayName='" + this.displayName + "', uri='" + this.uri + "'}";
    }

    public static class Builder {
        private final OptOutEntityIdentifier identifier;
        private String displayName;
        private String key;
        private String uri;

        public Builder(@Nonnull OptOutEntityIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier);
        }

        public Builder displayName(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder key(@Nullable String key) {
            this.key = key;
            return this;
        }

        public Builder uri(@Nullable String uri) {
            this.uri = uri;
            return this;
        }

        public OptOutEntity build() {
            return new OptOutEntity(this);
        }
    }
}

