/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.api.pagination;

import com.atlassian.business.insights.api.pagination.PageRequest;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class Page<T> {
    private final List<T> values;
    private final PageRequest nextPageRequest;

    private Page(Builder<T> builder) {
        this.values = builder.values;
        this.nextPageRequest = builder.nextPageRequest;
    }

    public static <T> Builder<T> builder(@Nonnull List<T> values, boolean lastPage) {
        return new Builder<T>(values, lastPage);
    }

    public boolean getIsLastPage() {
        return this.nextPageRequest == null;
    }

    @Nonnull
    public Optional<PageRequest> getNextPageRequest() {
        return Optional.ofNullable(this.nextPageRequest);
    }

    public int getSize() {
        return this.values.size();
    }

    @Nonnull
    public List<T> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return this.values.equals(page.values) && Objects.equals(this.nextPageRequest, page.nextPageRequest);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.nextPageRequest);
    }

    public static <T> Page<T> emptyPage() {
        return new Builder(Collections.emptyList(), true).build();
    }

    public static class Builder<T> {
        private PageRequest nextPageRequest;
        private final boolean lastPage;
        private final List<T> values;

        public Builder(@Nonnull List<T> values, boolean lastPage) {
            this.values = Collections.unmodifiableList(Objects.requireNonNull(values));
            this.lastPage = lastPage;
        }

        @Nonnull
        public Builder<T> nextPageRequest(PageRequest nextPageRequest) {
            this.nextPageRequest = nextPageRequest;
            return this;
        }

        @Nonnull
        public Page<T> build() {
            if (!this.lastPage) {
                Objects.requireNonNull(this.nextPageRequest, "nextPageRequest should be non-null except for last page");
            } else {
                this.nextPageRequest = null;
            }
            return new Page(this);
        }
    }
}

