/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.api.pagination;

import com.atlassian.annotations.ExperimentalApi;
import java.util.Objects;
import javax.annotation.Nonnull;

@ExperimentalApi
public class PageRequest {
    private final int offset;
    private final int limit;

    private PageRequest(Builder builder) {
        this.offset = builder.offset;
        this.limit = builder.limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageRequest that = (PageRequest)o;
        return this.offset == that.offset && this.limit == that.limit;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.limit);
    }

    public String toString() {
        return "PageRequest{offset=" + this.offset + ", limit=" + this.limit + "}";
    }

    public static class Builder {
        private static final int MAX_PAGE_LIMIT = 100000;
        private int offset;
        private int limit;

        @Nonnull
        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        @Nonnull
        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Nonnull
        public PageRequest build() {
            if (this.limit > 100000) {
                throw new IllegalArgumentException("Limit must be less than 100000");
            }
            return new PageRequest(this);
        }
    }
}

