/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.attribute;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class AttributeDefinition {
    private final String internalName;
    private final String exportName;

    public AttributeDefinition(@Nonnull String internalName, @Nonnull String exportName) {
        this.internalName = Objects.requireNonNull(internalName);
        this.exportName = Objects.requireNonNull(exportName);
    }

    @Nonnull
    public String getInternalName() {
        return this.internalName;
    }

    @Nonnull
    public String getExportName() {
        return this.exportName;
    }

    @Nonnull
    public static LinkedHashMap<String, String> toLinkedHashMap(List<AttributeDefinition> attributes) {
        return new LinkedHashMap<String, String>(attributes.stream().collect(Collectors.toMap(AttributeDefinition::getInternalName, AttributeDefinition::getExportName, (e1, e2) -> e1, LinkedHashMap::new)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributeDefinition)) {
            return false;
        }
        AttributeDefinition that = (AttributeDefinition)o;
        return Objects.equals(this.internalName, that.internalName) && Objects.equals(this.exportName, that.exportName);
    }

    public int hashCode() {
        return Objects.hash(this.internalName, this.exportName);
    }
}

