/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.config;

import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusService;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.business.insights.api.cluster.ClusterInfo;
import com.atlassian.business.insights.api.config.PropertiesProvider;
import com.atlassian.business.insights.api.dataset.Dataset;
import com.atlassian.business.insights.api.dataset.DatasetProvider;
import com.atlassian.business.insights.api.filter.OptOutEntitiesLookupService;
import com.atlassian.business.insights.api.filter.OptOutEntitiesTransformationService;
import com.atlassian.business.insights.api.user.RequestContext;
import com.atlassian.business.insights.bitbucket.config.BitbucketPropertiesProvider;
import com.atlassian.business.insights.bitbucket.dataset.BitbucketDatasetV1;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitToEntityTransformer;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitToLogRecordConverter;
import com.atlassian.business.insights.bitbucket.extract.commit.streaming.BitbucketCommitStreamer;
import com.atlassian.business.insights.bitbucket.extract.commit.streaming.CommitStreamer;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestActivityStreamer;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestStreamer;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestToLogRecordConverter;
import com.atlassian.business.insights.bitbucket.extract.repository.RepositoryStreamer;
import com.atlassian.business.insights.bitbucket.extract.repository.RepositoryToLogRecordConverter;
import com.atlassian.business.insights.bitbucket.extract.user.UserStreamer;
import com.atlassian.business.insights.bitbucket.extract.user.UserToLogRecordConverter;
import com.atlassian.business.insights.bitbucket.spi.BitbucketClusterInfo;
import com.atlassian.business.insights.bitbucket.spi.BitbucketOptOutEntitiesService;
import com.atlassian.business.insights.bitbucket.spi.BitbucketRequestContext;
import com.atlassian.business.insights.core.config.SystemThenSalPropertiesProvider;
import com.atlassian.business.insights.core.dataset.DefaultDatasetProvider;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.ApplicationProperties;
import java.util.List;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BitbucketPluginJavaConfig {
    @Bean
    public ApplicationPropertiesService applicationPropertiesService() {
        return OsgiServices.importOsgiService(ApplicationPropertiesService.class);
    }

    @Bean
    public ApplicationProperties applicationProperties() {
        return OsgiServices.importOsgiService(ApplicationProperties.class);
    }

    @Bean
    public PropertiesProvider propertiesProvider(ApplicationProperties applicationProperties) {
        return new SystemThenSalPropertiesProvider(applicationProperties);
    }

    @Bean
    public BitbucketPropertiesProvider bitbucketPropertiesProvider(PropertiesProvider propertiesProvider) {
        return new BitbucketPropertiesProvider(propertiesProvider);
    }

    @Bean
    public AuthenticationService authenticationService() {
        return OsgiServices.importOsgiService(AuthenticationService.class);
    }

    @Bean
    public UserAdminService userAdminService() {
        return OsgiServices.importOsgiService(UserAdminService.class);
    }

    @Bean
    public ClusterInfo bitbucketClusterInfo(ClusterService clusterService) {
        return new BitbucketClusterInfo(clusterService);
    }

    @Bean
    public ClusterService bitbucketClusterService() {
        return OsgiServices.importOsgiService(ClusterService.class);
    }

    @Bean
    public CommitService commitService() {
        return OsgiServices.importOsgiService(CommitService.class);
    }

    @Bean
    public UserService userService() {
        return OsgiServices.importOsgiService(UserService.class);
    }

    @Bean
    public CommitStreamer commitStreamer(BitbucketCommitStreamer bitbucketCommitStreamer, CommitToEntityTransformer commitToEntityTransformer, RepositoryService repositoryService, RequestContext requestContext, BitbucketPropertiesProvider propertiesProvider) {
        return new CommitStreamer(bitbucketCommitStreamer, commitToEntityTransformer, propertiesProvider, repositoryService, requestContext);
    }

    @Bean
    public CommitToEntityTransformer commitToEntityTransformer(RepositoryBuildStatusService repositoryBuildStatusService) {
        return new CommitToEntityTransformer(repositoryBuildStatusService);
    }

    @Bean
    public BitbucketCommitStreamer bitbucketCommitStreamer(BitbucketPropertiesProvider propertiesProvider, RefService refService, ScmService scmService) {
        return new BitbucketCommitStreamer(propertiesProvider, refService, scmService);
    }

    @Bean
    public ScmService scmService() {
        return OsgiServices.importOsgiService(ScmService.class);
    }

    @Bean
    public CommitToLogRecordConverter entityToLogRecordConverter(ApplicationPropertiesService applicationPropertiesService) {
        return new CommitToLogRecordConverter(applicationPropertiesService);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportBitbucketClusterInfo(ClusterInfo clusterInfo) {
        return OsgiServices.exportOsgiService(clusterInfo, ExportOptions.as(ClusterInfo.class, new Class[0]));
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportPropertiesProvider(PropertiesProvider propertiesProvider) {
        return OsgiServices.exportOsgiService(propertiesProvider, ExportOptions.as(PropertiesProvider.class, new Class[0]));
    }

    @Bean
    public PullRequestToLogRecordConverter pullRequestToLogRecordConverter(ApplicationPropertiesService applicationPropertiesService) {
        return new PullRequestToLogRecordConverter(applicationPropertiesService);
    }

    @Bean
    public UserStreamer userStreamer(UserService userService) {
        return new UserStreamer(userService);
    }

    @Bean
    public UserToLogRecordConverter userToLogRecordConverter(ApplicationPropertiesService applicationPropertiesService) {
        return new UserToLogRecordConverter(applicationPropertiesService);
    }

    @Bean
    public RefService refService() {
        return OsgiServices.importOsgiService(RefService.class);
    }

    @Bean
    public RepositoryBuildStatusService repositoryBuildStatusService() {
        return OsgiServices.importOsgiService(RepositoryBuildStatusService.class);
    }

    @Bean
    public RequestContext requestContext(AuthenticationService authenticationService, UserService userService, UserAdminService userAdminService, SecurityService securityService) {
        return new BitbucketRequestContext(authenticationService, userService, userAdminService, securityService);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportRequestContext(RequestContext requestContext) {
        return OsgiServices.exportOsgiService(requestContext, ExportOptions.as(RequestContext.class, new Class[0]));
    }

    @Bean
    public RepositoryService repositoryService() {
        return OsgiServices.importOsgiService(RepositoryService.class);
    }

    @Bean
    public PullRequestService pullRequestService() {
        return OsgiServices.importOsgiService(PullRequestService.class);
    }

    @Bean
    public PullRequestStreamer pullRequestStreamer(PullRequestService pullRequestService, PullRequestActivityStreamer pullRequestActivityStreamer) {
        return new PullRequestStreamer(pullRequestService, pullRequestActivityStreamer);
    }

    @Bean
    public PullRequestActivityStreamer pullRequestActivityStreamer(PullRequestService pullRequestService, BitbucketPropertiesProvider propertiesProvider) {
        if (propertiesProvider.isPullRequestActivitiesExportEnabled()) {
            return PullRequestActivityStreamer.getInstance(pullRequestService);
        }
        return PullRequestActivityStreamer.EMPTY_STREAMER;
    }

    @Bean
    public RepositoryStreamer repositoryStreamer(RepositoryService repositoryService) {
        return new RepositoryStreamer(repositoryService);
    }

    @Bean
    public RepositoryToLogRecordConverter repositoryToLogRecordConverter(ApplicationPropertiesService propertiesService) {
        return new RepositoryToLogRecordConverter(propertiesService);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportDatasetProvider(List<Dataset> datasets, RequestContext requestContext) {
        return OsgiServices.exportOsgiService(new DefaultDatasetProvider(datasets, requestContext), ExportOptions.as(DatasetProvider.class, new Class[0]));
    }

    @Bean
    public Dataset datasetV1(CommitStreamer commitStreamer, CommitToLogRecordConverter commitToLogRecordConverter, PullRequestStreamer pullRequestStreamer, PullRequestToLogRecordConverter pullRequestToLogRecordConverter, RepositoryStreamer repositoryStreamer, RepositoryToLogRecordConverter repositoryToLogRecordConverter, UserStreamer userStreamer, UserToLogRecordConverter userToLogRecordConverter, BitbucketPropertiesProvider propertiesProvider) {
        return new BitbucketDatasetV1(commitStreamer, commitToLogRecordConverter, pullRequestStreamer, pullRequestToLogRecordConverter, repositoryStreamer, repositoryToLogRecordConverter, userStreamer, userToLogRecordConverter, propertiesProvider);
    }

    @Bean
    public SecurityService securityService() {
        return OsgiServices.importOsgiService(SecurityService.class);
    }

    @Bean
    public NavBuilder navBuilder() {
        return OsgiServices.importOsgiService(NavBuilder.class);
    }

    @Bean
    public ProjectService projectService() {
        return OsgiServices.importOsgiService(ProjectService.class);
    }

    @Bean
    public BitbucketOptOutEntitiesService bitbucketOptOutEntitiesService(ProjectService projectService, NavBuilder navBuilder) {
        return new BitbucketOptOutEntitiesService(projectService, navBuilder);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportOptOutEntitiesLookupService(BitbucketOptOutEntitiesService bitbucketOptOutResourcesService) {
        return OsgiServices.exportOsgiService(bitbucketOptOutResourcesService, ExportOptions.as(OptOutEntitiesLookupService.class, new Class[0]));
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportOptOutEntitiesTransformationService(BitbucketOptOutEntitiesService bitbucketOptOutResourcesService) {
        return OsgiServices.exportOsgiService(bitbucketOptOutResourcesService, ExportOptions.as(OptOutEntitiesTransformationService.class, new Class[0]));
    }
}

