/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.config;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.business.insights.api.config.PropertiesProvider;

public class BitbucketPropertiesProvider {
    public static final long DEFAULT_GIT_EXECUTION_TIMEOUT_SECONDS = 7200L;
    public static final long DEFAULT_GIT_IDLE_TIMEOUT_SECONDS = 3600L;
    public static final long DEFAULT_QUEUE_POLLING_TIMEOUT_SECONDS = 3600L;
    @VisibleForTesting
    static final String GIT_EXECUTION_TIMEOUT_PROPERTY = "plugin.data.pipeline.bitbucket.commit.git.execution.timeout.seconds";
    @VisibleForTesting
    static final String GIT_IDLE_TIMEOUT_PROPERTY = "plugin.data.pipeline.bitbucket.commit.git.idle.timeout.seconds";
    @VisibleForTesting
    static final String QUEUE_POLLING_TIMEOUT_PROPERTY = "plugin.data.pipeline.bitbucket.commit.queue.polling.timeout.seconds";
    @VisibleForTesting
    static final String EXPORT_FORKED_REPOS_IN_PERSONAL_PROJECTS_PROPERTY = "plugin.data.pipeline.bitbucket.export.personal.forked.repository.commits";
    @VisibleForTesting
    static final String EXPORT_BUILD_STATUSES_PROPERTY = "plugin.data.pipeline.bitbucket.export.build.statuses";
    @VisibleForTesting
    static final String EXPORT_PULL_REQUEST_ACTIVITIES_PROPERTY = "plugin.data.pipeline.bitbucket.export.pull.request.activities";
    private final PropertiesProvider propertiesProvider;

    public BitbucketPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.propertiesProvider = propertiesProvider;
    }

    public long getGitExecutionTimeout() {
        return Long.parseLong(this.propertiesProvider.getProperty(GIT_EXECUTION_TIMEOUT_PROPERTY, String.valueOf(7200L)));
    }

    public long getGitIdleTimeout() {
        return Long.parseLong(this.propertiesProvider.getProperty(GIT_IDLE_TIMEOUT_PROPERTY, String.valueOf(3600L)));
    }

    public long getQueuePollingTimeout() {
        return Long.parseLong(this.propertiesProvider.getProperty(QUEUE_POLLING_TIMEOUT_PROPERTY, String.valueOf(3600L)));
    }

    public boolean isForkedReposInPersonalProjectsExportEnabled() {
        return this.propertiesProvider.getBoolean(EXPORT_FORKED_REPOS_IN_PERSONAL_PROJECTS_PROPERTY);
    }

    public boolean isBuildStatusesExportEnabled() {
        return this.propertiesProvider.getBoolean(EXPORT_BUILD_STATUSES_PROPERTY);
    }

    public boolean isPullRequestActivitiesExportEnabled() {
        return this.propertiesProvider.getBoolean(EXPORT_PULL_REQUEST_ACTIVITIES_PROPERTY, true);
    }
}

