/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.dataset;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.business.insights.api.dataset.DataChannel;
import com.atlassian.business.insights.api.dataset.Dataset;
import com.atlassian.business.insights.attribute.AttributeDefinition;
import com.atlassian.business.insights.bitbucket.attribute.CommitAttributes;
import com.atlassian.business.insights.bitbucket.attribute.PullRequestsAttributes;
import com.atlassian.business.insights.bitbucket.attribute.RepositoriesAttributes;
import com.atlassian.business.insights.bitbucket.attribute.UserAttributes;
import com.atlassian.business.insights.bitbucket.config.BitbucketPropertiesProvider;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitDetails;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitToLogRecordConverter;
import com.atlassian.business.insights.bitbucket.extract.commit.streaming.CommitStreamer;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestDetails;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestStreamer;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestToLogRecordConverter;
import com.atlassian.business.insights.bitbucket.extract.repository.RepositoryStreamer;
import com.atlassian.business.insights.bitbucket.extract.repository.RepositoryToLogRecordConverter;
import com.atlassian.business.insights.bitbucket.extract.user.UserStreamer;
import com.atlassian.business.insights.bitbucket.extract.user.UserToLogRecordConverter;
import com.atlassian.business.insights.bitbucket.schema.BitbucketBuildStatusAwareSchemaV1;
import com.atlassian.business.insights.bitbucket.schema.BitbucketPullRequestActivitiesFileSchema;
import com.atlassian.business.insights.core.dataset.DefaultDataChannel;
import com.atlassian.business.insights.core.extract.DefaultLogRecordStreamer;
import com.atlassian.business.insights.core.schema.ColumnFileSchema;
import com.atlassian.business.insights.core.schema.DefaultSchema;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class BitbucketDatasetV1
implements Dataset {
    @VisibleForTesting
    public static final String USERS_FILE_NAME = "users";
    @VisibleForTesting
    public static final String PULL_REQUESTS_FILE_NAME = "pull_requests";
    @VisibleForTesting
    public static final String REPOSITORIES_FILE_NAME = "repositories";
    @VisibleForTesting
    public static final String COMMITS_FILE_NAME = "commits";
    private static final String DEFAULT_DATASET_DESC = "Bitbucket Dataset V1 - repositories,pull requests,commits,users";
    private static final int VERSION = 1;
    private final List<DataChannel> dataChannels;

    public BitbucketDatasetV1(CommitStreamer commitStreamer, CommitToLogRecordConverter commitToLogRecordConverter, PullRequestStreamer pullRequestStreamer, PullRequestToLogRecordConverter pullRequestToLogRecordConverter, RepositoryStreamer repositoryStreamer, RepositoryToLogRecordConverter repositoryToLogRecordConverter, UserStreamer userStreamer, UserToLogRecordConverter userToLogRecordConverter, BitbucketPropertiesProvider propertiesProvider) {
        BitbucketBuildStatusAwareSchemaV1 commitSchema = new BitbucketBuildStatusAwareSchemaV1(new DefaultSchema(COMMITS_FILE_NAME, Collections.singletonList(new ColumnFileSchema(COMMITS_FILE_NAME, AttributeDefinition.toLinkedHashMap(CommitAttributes.getAttributes()))), 1), propertiesProvider);
        DefaultSchema pullRequestSchema = new DefaultSchema(PULL_REQUESTS_FILE_NAME, Arrays.asList(new ColumnFileSchema(PULL_REQUESTS_FILE_NAME, AttributeDefinition.toLinkedHashMap(PullRequestsAttributes.getAttributes())), new BitbucketPullRequestActivitiesFileSchema(propertiesProvider.isPullRequestActivitiesExportEnabled())), 1);
        DefaultSchema repoSchema = new DefaultSchema(REPOSITORIES_FILE_NAME, Collections.singletonList(new ColumnFileSchema(REPOSITORIES_FILE_NAME, AttributeDefinition.toLinkedHashMap(RepositoriesAttributes.getAttributes()))), 1);
        DefaultSchema userSchema = new DefaultSchema(USERS_FILE_NAME, Collections.singletonList(new ColumnFileSchema(USERS_FILE_NAME, AttributeDefinition.toLinkedHashMap(UserAttributes.getAttributes()))), 1);
        this.dataChannels = ImmutableList.of((Object)new DefaultDataChannel(commitSchema, new DefaultLogRecordStreamer<String, CommitDetails>(commitStreamer, commitToLogRecordConverter)), (Object)new DefaultDataChannel(userSchema, new DefaultLogRecordStreamer<Integer, ApplicationUser>(userStreamer, userToLogRecordConverter)), (Object)new DefaultDataChannel(pullRequestSchema, new DefaultLogRecordStreamer<Long, PullRequestDetails>(pullRequestStreamer, pullRequestToLogRecordConverter)), (Object)new DefaultDataChannel(repoSchema, new DefaultLogRecordStreamer<Integer, Repository>(repositoryStreamer, repositoryToLogRecordConverter)));
    }

    @Override
    @Nonnull
    public String getDescription() {
        return DEFAULT_DATASET_DESC;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    @Nonnull
    public List<DataChannel> getChannels() {
        return this.dataChannels;
    }
}

