/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.commit;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.business.insights.bitbucket.extract.commit.SimpleBuildStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CommitDetails {
    private final List<SimpleBuildStatus> buildStatus;
    private final Commit commit;
    private final Date committedDate;
    private final String id;

    private CommitDetails(Builder builder) {
        this.id = builder.id;
        this.commit = builder.commit;
        this.committedDate = builder.committedDate;
        this.buildStatus = builder.buildStatus;
    }

    @Nonnull
    public List<SimpleBuildStatus> getBuildStatus() {
        return this.buildStatus;
    }

    @Nonnull
    public Commit getCommit() {
        return this.commit;
    }

    @Nonnull
    public Date getCommittedDate() {
        return this.committedDate;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public static class Builder {
        private final Commit commit;
        private final Date committedDate;
        private final String id;
        private List<SimpleBuildStatus> buildStatus;

        public Builder(@Nonnull Commit commit) {
            Objects.requireNonNull(commit);
            this.id = commit.getId();
            this.commit = commit;
            this.committedDate = commit.getCommitterTimestamp();
            this.buildStatus = new ArrayList<SimpleBuildStatus>();
        }

        @Nonnull
        public CommitDetails build() {
            return new CommitDetails(this);
        }

        @Nonnull
        public Builder repositoryBuildStatus(@Nonnull List<SimpleBuildStatus> repositoryBuildStatus) {
            this.buildStatus = Objects.requireNonNull(repositoryBuildStatus);
            return this;
        }
    }
}

