/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.commit;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitDetails;
import com.atlassian.business.insights.bitbucket.extract.commit.SimpleBuildStatus;
import com.atlassian.business.insights.core.util.DateTimeConverter;
import com.atlassian.business.insights.core.util.TextConverter;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitDocument {
    private final List<SimpleBuildStatus> buildStatus;
    private final Commit commit;
    private final ApplicationPropertiesService propertiesService;

    public CommitDocument(@Nonnull ApplicationPropertiesService propertiesService, @Nonnull CommitDetails commitDetails) {
        Objects.requireNonNull(commitDetails, "commitDetails must not be null");
        this.propertiesService = Objects.requireNonNull(propertiesService, "propertiesService must not be null");
        this.commit = commitDetails.getCommit();
        this.buildStatus = commitDetails.getBuildStatus();
    }

    @Nullable
    public String getAuthorEmail() {
        return this.commit.getAuthor().getEmailAddress();
    }

    @Nonnull
    public String getAuthorTimestamp() {
        return DateTimeConverter.convertTimestampToDateTime(this.commit.getAuthorTimestamp().toInstant());
    }

    @Nonnull
    public List<SimpleBuildStatus> getBuildStatuses() {
        return this.buildStatus;
    }

    @Nullable
    public String getCommitMessage() {
        return TextConverter.truncateText(this.commit.getMessage());
    }

    @Nullable
    public String getCommitterEmail() {
        return this.commit.getCommitter().getEmailAddress();
    }

    @Nonnull
    public String getCommitterTimestamp() {
        return DateTimeConverter.convertTimestampToDateTime(this.commit.getCommitterTimestamp().toInstant());
    }

    @Nonnull
    public String getId() {
        return this.commit.getId();
    }

    @Nullable
    public String getInstanceUrl() {
        return this.propertiesService.getBaseUrl() == null ? null : this.propertiesService.getBaseUrl().toString();
    }

    @Nullable
    public Integer getRepositoryId() {
        return this.commit.getRepository() == null ? null : Integer.valueOf(this.commit.getRepository().getId());
    }

    @Nullable
    public String getUrl() {
        Repository repo = this.commit.getRepository();
        if (repo == null || this.getInstanceUrl() == null) {
            return null;
        }
        String projectKey = repo.getProject().getKey();
        return this.getInstanceUrl() + "/projects/" + projectKey + "/repos/" + repo.getSlug() + "/commits/" + this.getId();
    }
}

