/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.commit;

import com.atlassian.bitbucket.build.status.BuildStatusRepositorySearchRequest;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusService;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.business.insights.api.Entity;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitDetails;
import com.atlassian.business.insights.bitbucket.extract.commit.SimpleBuildStatus;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitToEntityTransformer {
    private static final int BUILD_STATUS_PAGE_SIZE = 500;
    private static final Logger log = LoggerFactory.getLogger(CommitToEntityTransformer.class);
    private final RepositoryBuildStatusService repositoryBuildStatusService;

    public CommitToEntityTransformer(RepositoryBuildStatusService repositoryBuildStatusService) {
        this.repositoryBuildStatusService = repositoryBuildStatusService;
    }

    public Entity<String, CommitDetails> toEntity(@Nonnull Commit commit, boolean includeBuildStatuses) {
        Objects.requireNonNull(commit, "commit");
        CommitDetails commitDetails = new CommitDetails.Builder(commit).repositoryBuildStatus(this.getBuildStatusesIfEnabled(commit, includeBuildStatuses)).build();
        return Entity.getInstance(commitDetails.getId(), commitDetails.getCommittedDate().toInstant(), commitDetails);
    }

    private List<SimpleBuildStatus> getBuildStatusesIfEnabled(@Nonnull Commit commit, boolean includeBuildStatuses) {
        if (includeBuildStatuses) {
            return this.getBuildStatuses(commit);
        }
        return ImmutableList.of();
    }

    private List<SimpleBuildStatus> getBuildStatuses(Commit commit) {
        ArrayList<SimpleBuildStatus> buildStatuses = new ArrayList<SimpleBuildStatus>();
        if (commit.getRepository() == null) {
            log.warn("No repository found for commit: " + commit.getId());
            return buildStatuses;
        }
        PageRequestImpl buildStatusPageRequest = new PageRequestImpl(0, 500);
        while (buildStatusPageRequest != null) {
            PageRequestImpl finalBuildStatusPageRequest = buildStatusPageRequest;
            Page buildStatusPage = this.repositoryBuildStatusService.search(((BuildStatusRepositorySearchRequest.Builder)new BuildStatusRepositorySearchRequest.Builder(commit.getRepository()).commitId(commit.getId())).build(), (PageRequest)finalBuildStatusPageRequest);
            buildStatusPageRequest = buildStatusPage.getNextPageRequest();
            buildStatusPage.forEach(buildStatus -> buildStatuses.add(new SimpleBuildStatus((RepositoryBuildStatus)buildStatus)));
        }
        return buildStatuses;
    }
}

