/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.commit;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.business.insights.api.Entity;
import com.atlassian.business.insights.api.LogRecord;
import com.atlassian.business.insights.api.extract.EntityToLogRecordConverter;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitDetails;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitDocument;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.HashMap;
import java.util.Map;

public class CommitToLogRecordConverter
implements EntityToLogRecordConverter<String, CommitDetails> {
    private static final TypeReference<HashMap<String, Object>> TYPE_REFERENCE = new TypeReference<HashMap<String, Object>>(){};
    private final ApplicationPropertiesService applicationPropertiesService;
    private final ObjectMapper objectMapper = new ObjectMapper().registerModules(new Module[]{new JavaTimeModule(), new Jdk8Module()});

    public CommitToLogRecordConverter(ApplicationPropertiesService applicationPropertiesService) {
        this.applicationPropertiesService = applicationPropertiesService;
    }

    @Override
    public LogRecord<String> convert(Entity<String, CommitDetails> entity) {
        Map<String, Object> payload = this.serialize(entity.getValue());
        return LogRecord.getInstance(entity.getId(), entity.getTimestamp(), payload);
    }

    private Map<String, Object> serialize(CommitDetails commit) {
        return (Map)this.objectMapper.convertValue((Object)new CommitDocument(this.applicationPropertiesService, commit), TYPE_REFERENCE);
    }
}

