/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.commit;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.build.status.TestResults;
import com.atlassian.business.insights.core.util.DateTimeConverter;
import com.atlassian.business.insights.core.util.TextConverter;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class SimpleBuildStatus {
    private final Optional<String> buildNumber;
    private final Date createdDate;
    private final Optional<String> description;
    private final Optional<Long> duration;
    private final String key;
    private final Optional<String> name;
    private final Optional<String> parent;
    private final Optional<String> ref;
    private final BuildState state;
    private final Optional<TestResults> testResults;
    private final Date updatedDate;
    private final String url;

    public SimpleBuildStatus(@Nonnull RepositoryBuildStatus buildStatus) {
        Objects.requireNonNull(buildStatus);
        this.buildNumber = buildStatus.getBuildNumber();
        this.duration = buildStatus.getDuration();
        this.createdDate = buildStatus.getCreatedDate();
        this.updatedDate = buildStatus.getUpdatedDate();
        this.description = buildStatus.getDescription();
        this.key = buildStatus.getKey();
        this.name = buildStatus.getName();
        this.parent = buildStatus.getParent();
        this.ref = buildStatus.getRef();
        this.state = buildStatus.getState();
        this.url = buildStatus.getUrl();
        this.testResults = buildStatus.getTestResults();
    }

    public Optional<String> getBuildNumber() {
        return this.buildNumber;
    }

    @Nonnull
    public String getCreatedDate() {
        return DateTimeConverter.convertTimestampToDateTime(this.createdDate.toInstant());
    }

    public Optional<String> getDescription() {
        return this.description.map(TextConverter::truncateText);
    }

    public long getDuration() {
        return this.duration.orElse(0L);
    }

    public int getFailedTests() {
        return this.testResults.flatMap(TestResults::getFailed).orElse(0);
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getParent() {
        return this.parent;
    }

    public Optional<String> getRef() {
        return this.ref;
    }

    public int getSkippedTests() {
        return this.testResults.flatMap(TestResults::getSkipped).orElse(0);
    }

    @Nonnull
    public BuildState getState() {
        return this.state;
    }

    public int getSuccessfulTests() {
        return this.testResults.flatMap(TestResults::getSuccessful).orElse(0);
    }

    @Nonnull
    public String getUpdatedDate() {
        return DateTimeConverter.convertTimestampToDateTime(this.updatedDate.toInstant());
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleBuildStatus that = (SimpleBuildStatus)o;
        return Objects.equals(this.buildNumber, that.buildNumber) && Objects.equals(this.createdDate, that.createdDate) && Objects.equals(this.description, that.description) && Objects.equals(this.duration, that.duration) && Objects.equals(this.key, that.key) && Objects.equals(this.name, that.name) && Objects.equals(this.parent, that.parent) && Objects.equals(this.ref, that.ref) && this.state == that.state && Objects.equals(this.testResults, that.testResults) && Objects.equals(this.updatedDate, that.updatedDate) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.buildNumber, this.createdDate, this.description, this.duration, this.key, this.name, this.parent, this.ref, this.state, this.testResults, this.updatedDate, this.url);
    }
}

