/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.commit.streaming;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.business.insights.bitbucket.config.BitbucketPropertiesProvider;
import com.atlassian.business.insights.bitbucket.extract.commit.streaming.CommitSinceDateValidator;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketCommitStreamer {
    @VisibleForTesting
    public static final int MAX_COMMIT_MSG_LENGTH = 2000;
    private static final Logger log = LoggerFactory.getLogger(BitbucketCommitStreamer.class);
    private final long gitExecutionTimeout;
    private final long gitIdleTimeout;
    private final RefService refService;
    private final ScmService scmService;

    public BitbucketCommitStreamer(BitbucketPropertiesProvider propertiesProvider, RefService refService, ScmService scmService) {
        this.refService = refService;
        this.scmService = scmService;
        this.gitExecutionTimeout = propertiesProvider.getGitExecutionTimeout();
        this.gitIdleTimeout = propertiesProvider.getGitIdleTimeout();
    }

    public void streamCommits(@Nonnull CommitCallback commitCallback, @Nonnull Repository repository, @Nonnull Instant commitsSince) {
        Objects.requireNonNull(commitCallback, "commitCallback");
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(commitsSince, "commitsSince");
        try {
            String latestCommit = this.refService.getDefaultBranch(repository).getLatestCommit();
            this.streamCommits(repository, commitsSince, latestCommit, commitCallback);
        }
        catch (NoDefaultBranchException e) {
            log.info("Could not find default branch for repository with slug [{}]", (Object)repository.getSlug());
        }
    }

    private void streamCommits(Repository repository, Instant commitsSince, String latestCommit, CommitCallback commitCallback) {
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory(repository);
        CommitsCommandParameters.Builder parametersBuilder = new CommitsCommandParameters.Builder().include(latestCommit, new String[0]).maxMessageLength(2000);
        if (CommitSinceDateValidator.isSupported(commitsSince)) {
            parametersBuilder.since(commitsSince);
        }
        CommitsCommandParameters parameters = parametersBuilder.build();
        Command commitsCommand = commandFactory.commits(parameters, commitCallback);
        commitsCommand.setExecutionTimeout(this.gitExecutionTimeout);
        commitsCommand.setIdleTimeout(this.gitIdleTimeout);
        commitsCommand.call();
    }
}

