/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.commit.streaming;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.SimplePerson;
import com.atlassian.business.insights.api.Entity;
import com.atlassian.business.insights.api.extract.EntityStreamerQuery;
import com.atlassian.business.insights.api.user.RequestContext;
import com.atlassian.business.insights.bitbucket.config.BitbucketPropertiesProvider;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitDetails;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitToEntityTransformer;
import com.atlassian.business.insights.bitbucket.extract.commit.streaming.BitbucketCommitStreamer;
import com.atlassian.business.insights.bitbucket.extract.commit.streaming.CommitStreamingException;
import com.atlassian.business.insights.bitbucket.extract.commit.streaming.SingleGitRepositoryIterator;
import com.atlassian.business.insights.bitbucket.extract.filter.BitbucketProjectOptOutFilter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitIterator
implements Iterator<Entity<String, CommitDetails>> {
    private static final int MAX_COMMIT_QUEUE_SIZE = 2000;
    private static final Entity<String, CommitDetails> POISON_PILL = Entity.getInstance("POISON_PILL", Instant.EPOCH, new CommitDetails.Builder((Commit)new SimpleCommit.Builder("poison.pill.commit.id").author((Person)new SimplePerson("Mr. Poison Pill", "ppill@atlassian.com")).authorTimestamp(new Date()).build()).build());
    private static final Logger log = LoggerFactory.getLogger(CommitIterator.class);
    private final BiCommitCallback biCommitCallback;
    private final BitbucketCommitStreamer bitbucketCommitStreamer;
    private final AtomicReference<Throwable> childThreadThrowable = new AtomicReference();
    private final CommitToEntityTransformer commitToEntityTransformer;
    private final BlockingQueue<Entity<String, CommitDetails>> commitsQueue = new LinkedBlockingQueue<Entity<String, CommitDetails>>(2000);
    private final Instant commitsSince;
    private final AtomicBoolean continueCommitStreaming = new AtomicBoolean(true);
    private final long queuePollingTimeoutSeconds;
    private final RequestContext requestContext;
    private final SingleGitRepositoryIterator singleGitRepositoryIterator;
    private final boolean includeBuildStatuses;

    public CommitIterator(BitbucketCommitStreamer bitbucketCommitStreamer, CommitToEntityTransformer commitToEntityTransformer, EntityStreamerQuery entityStreamerQuery, RepositoryService repositoryService, RequestContext requestContext, BitbucketPropertiesProvider propertiesProvider) {
        this.bitbucketCommitStreamer = bitbucketCommitStreamer;
        this.commitsSince = entityStreamerQuery.getFrom();
        this.requestContext = requestContext;
        this.commitToEntityTransformer = commitToEntityTransformer;
        this.biCommitCallback = new BiCommitCallback();
        BitbucketProjectOptOutFilter bitbucketProjectOptOutFilter = new BitbucketProjectOptOutFilter(entityStreamerQuery.getOptOutEntityIdentifiers());
        this.singleGitRepositoryIterator = new SingleGitRepositoryIterator(repositoryService, propertiesProvider, bitbucketProjectOptOutFilter);
        this.queuePollingTimeoutSeconds = propertiesProvider.getQueuePollingTimeout();
        this.includeBuildStatuses = propertiesProvider.isBuildStatusesExportEnabled();
        new ThrowablePropagatingExecutor().submit(this::produceCommits);
    }

    public void close() {
        this.rethrowExceptionInChildThreadIfExists();
        this.commitsQueue.clear();
        this.continueCommitStreaming.set(false);
    }

    @Override
    public boolean hasNext() {
        this.rethrowExceptionInChildThreadIfExists();
        if (this.commitsQueue.peek() == POISON_PILL) {
            this.continueCommitStreaming.set(false);
            return false;
        }
        return this.continueCommitStreaming.get() || !this.commitsQueue.isEmpty();
    }

    @Override
    public Entity<String, CommitDetails> next() {
        this.rethrowExceptionInChildThreadIfExists();
        try {
            Entity<String, CommitDetails> entity = this.commitsQueue.poll(this.queuePollingTimeoutSeconds, TimeUnit.SECONDS);
            if (entity == null) {
                this.rethrowExceptionInChildThreadIfExists();
                this.continueCommitStreaming.set(false);
                throw new CommitStreamingException(String.format("Timeout after %d seconds when waiting for the commit to be polled off queue", this.queuePollingTimeoutSeconds));
            }
            if (entity == POISON_PILL) {
                log.debug("Retrieved poison pill from queue");
                this.continueCommitStreaming.set(false);
                entity = null;
            }
            return entity;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommitStreamingException("Interrupted while polling commits from queue", e);
        }
    }

    private void produceCommits() {
        log.debug("Starting commit entity producing");
        this.requestContext.runInCustomContext(() -> {
            while (this.continueCommitStreaming.get() && this.singleGitRepositoryIterator.hasNext()) {
                Repository repository = (Repository)this.singleGitRepositoryIterator.next();
                if (repository == null) continue;
                log.debug("Streaming commits for repository [{}]", (Object)repository.getId());
                this.bitbucketCommitStreamer.streamCommits(this.biCommitCallback, repository, this.commitsSince);
            }
            try {
                this.commitsQueue.put(POISON_PILL);
                log.debug("Added poison pill to queue");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CommitStreamingException("Error when adding poison pill to queue", e);
            }
            log.debug("Finished streaming commits for all repositories");
        });
    }

    private void rethrowExceptionInChildThreadIfExists() {
        if (this.childThreadThrowable.get() != null) {
            if (this.childThreadThrowable.get() instanceof CommitStreamingException) {
                throw (CommitStreamingException)this.childThreadThrowable.get();
            }
            if (this.childThreadThrowable.get() instanceof ExecutionException && this.childThreadThrowable.get().getCause() instanceof CommitStreamingException) {
                throw (CommitStreamingException)this.childThreadThrowable.get().getCause();
            }
            throw new CommitStreamingException("Error in child thread during commit streaming : " + this.childThreadThrowable.get().getMessage(), this.childThreadThrowable.get());
        }
    }

    private class BiCommitCallback
    implements CommitCallback {
        private BiCommitCallback() {
        }

        public boolean onCommit(@Nonnull Commit commit) {
            try {
                Entity<String, CommitDetails> commitDetailsEntity = CommitIterator.this.commitToEntityTransformer.toEntity(commit, CommitIterator.this.includeBuildStatuses);
                CommitIterator.this.commitsQueue.put(commitDetailsEntity);
                log.trace("Added commitsDetailsEntity to the queue with commit {}. Queue size: {}", (Object)commit.getId(), (Object)CommitIterator.this.commitsQueue.size());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CommitStreamingException("Error when adding commit details to queue", e);
            }
            return CommitIterator.this.continueCommitStreaming.get();
        }
    }

    private class ThrowablePropagatingExecutor
    extends ThreadPoolExecutor {
        public ThrowablePropagatingExecutor() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("data-pipeline-commit-streamer-%d").build());
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            Throwable throwableToRethrow = t;
            if (throwableToRethrow == null && r instanceof Future) {
                try {
                    Future future = (Future)((Object)r);
                    if (future.isDone()) {
                        future.get();
                    }
                }
                catch (CancellationException | ExecutionException e) {
                    throwableToRethrow = e;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throwableToRethrow = e;
                }
            }
            CommitIterator.this.childThreadThrowable.set(throwableToRethrow);
            if (CommitIterator.this.childThreadThrowable.get() != null) {
                CommitIterator.this.continueCommitStreaming.set(false);
            }
        }
    }
}

