/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.commit.streaming;

import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.business.insights.api.Entity;
import com.atlassian.business.insights.api.extract.EntityStreamer;
import com.atlassian.business.insights.api.extract.EntityStreamerQuery;
import com.atlassian.business.insights.api.extract.StreamerValidationResult;
import com.atlassian.business.insights.api.user.RequestContext;
import com.atlassian.business.insights.bitbucket.config.BitbucketPropertiesProvider;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitDetails;
import com.atlassian.business.insights.bitbucket.extract.commit.CommitToEntityTransformer;
import com.atlassian.business.insights.bitbucket.extract.commit.streaming.BitbucketCommitStreamer;
import com.atlassian.business.insights.bitbucket.extract.commit.streaming.CommitIterator;
import com.atlassian.business.insights.bitbucket.extract.commit.streaming.CommitSinceDateValidator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitStreamer
implements EntityStreamer<String, CommitDetails> {
    private static final Logger log = LoggerFactory.getLogger(CommitStreamer.class);
    private final BitbucketCommitStreamer bitbucketCommitStreamer;
    private final CommitToEntityTransformer commitToEntityTransformer;
    private final BitbucketPropertiesProvider propertiesProvider;
    private final RepositoryService repositoryService;
    private final RequestContext requestContext;

    public CommitStreamer(BitbucketCommitStreamer bitbucketCommitStreamer, CommitToEntityTransformer commitToEntityTransformer, BitbucketPropertiesProvider propertiesProvider, RepositoryService repositoryService, RequestContext requestContext) {
        this.repositoryService = repositoryService;
        this.requestContext = requestContext;
        this.propertiesProvider = propertiesProvider;
        this.commitToEntityTransformer = commitToEntityTransformer;
        this.bitbucketCommitStreamer = bitbucketCommitStreamer;
    }

    @Override
    @Nonnull
    public StreamerValidationResult isReady() {
        return StreamerValidationResult.pass();
    }

    @Override
    public Stream<Entity<String, CommitDetails>> stream(@Nonnull EntityStreamerQuery entityStreamerQuery) {
        Objects.requireNonNull(entityStreamerQuery, "entityStreamerQuery");
        if (!CommitSinceDateValidator.isSupported(entityStreamerQuery.getFrom())) {
            log.warn("The provided fromDate is not supported for git commit streaming. The entered date must be after 1973-03-03T09:46:40Z. All commits in the instance will be streamed.");
        }
        CommitIterator commitIterator = new CommitIterator(this.bitbucketCommitStreamer, this.commitToEntityTransformer, entityStreamerQuery, this.repositoryService, this.requestContext, this.propertiesProvider);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(commitIterator, 1024), false).filter(Objects::nonNull).onClose(commitIterator::close);
    }
}

