/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.commit.streaming;

import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.business.insights.bitbucket.config.BitbucketPropertiesProvider;
import com.atlassian.business.insights.bitbucket.extract.filter.BitbucketProjectOptOutFilter;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.Deque;

public class SingleGitRepositoryIterator
extends AbstractIterator<Repository> {
    private static final int REPOSITORY_PAGE_SIZE = 10;
    private final Deque<Repository> repositories = new ArrayDeque<Repository>(10);
    private final RepositoryService repositoryService;
    private final boolean includeForkedReposInPersonalProjects;
    private final BitbucketProjectOptOutFilter bitbucketProjectOptOutFilter;
    private PageRequest nextRepositoryPageRequest = new PageRequestImpl(0, 10);

    public SingleGitRepositoryIterator(RepositoryService repositoryService, BitbucketPropertiesProvider propertiesProvider, BitbucketProjectOptOutFilter bitbucketProjectOptOutFilter) {
        this.repositoryService = repositoryService;
        this.includeForkedReposInPersonalProjects = propertiesProvider.isForkedReposInPersonalProjectsExportEnabled();
        this.bitbucketProjectOptOutFilter = bitbucketProjectOptOutFilter;
    }

    protected Repository computeNext() {
        while (this.repositories.isEmpty()) {
            if (this.nextRepositoryPageRequest == null) {
                return (Repository)this.endOfData();
            }
            this.requestRepositories();
        }
        return this.repositories.poll();
    }

    private void requestRepositories() {
        Page repoPage = this.repositoryService.findAll(this.nextRepositoryPageRequest);
        repoPage.stream().filter(this::isNotInOptedOutProjects).filter(this::validatePersonalForkedReposIfRequired).filter(repository -> repository.getScmId().equals("git")).forEach(this.repositories::add);
        this.nextRepositoryPageRequest = repoPage.getNextPageRequest();
    }

    private boolean validatePersonalForkedReposIfRequired(Repository repository) {
        return this.includeForkedReposInPersonalProjects || !repository.isFork() || !ProjectType.PERSONAL.equals((Object)repository.getProject().getType());
    }

    private boolean isNotInOptedOutProjects(Repository repository) {
        return this.bitbucketProjectOptOutFilter.test(repository.getProject().getId());
    }
}

