/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.filter;

import com.atlassian.business.insights.api.filter.OptOutEntityIdentifier;
import com.atlassian.business.insights.api.filter.OptOutEntityType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BitbucketProjectOptOutFilter
implements Predicate<Integer> {
    private final Set<Integer> optedOutProjectIds;

    public BitbucketProjectOptOutFilter(@Nonnull List<OptOutEntityIdentifier> optOutEntityIdentifiers) {
        Objects.requireNonNull(optOutEntityIdentifiers, "optOutEntityIdentifiers must not be null");
        this.optedOutProjectIds = optOutEntityIdentifiers.stream().filter(optOutResourceIdentifier -> OptOutEntityType.PROJECT == optOutResourceIdentifier.getType()).map(OptOutEntityIdentifier::getIdentifier).map(Integer::valueOf).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public boolean test(@Nullable Integer projectId) {
        return Optional.ofNullable(projectId).map(nonNullProjectId -> !this.optedOutProjectIds.contains(nonNullProjectId)).orElse(true);
    }
}

