/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.pullrequest;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.business.insights.core.util.DateTimeConverter;
import com.atlassian.business.insights.core.util.TextConverter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class PullRequestActivityDocument {
    private final PullRequestActivity pullRequestActivity;
    private final String pullRequestId;

    public PullRequestActivityDocument(@Nonnull PullRequestActivity pullRequestActivity, @Nonnull String pullRequestId) {
        this.pullRequestActivity = Objects.requireNonNull(pullRequestActivity, "pullRequestActivity must not be null");
        this.pullRequestId = Objects.requireNonNull(pullRequestId, "pullRequestId must not be null");
    }

    public long getId() {
        return this.pullRequestActivity.getId();
    }

    @Nonnull
    public String getPullRequestId() {
        return this.pullRequestId;
    }

    public int getAuthorId() {
        return this.pullRequestActivity.getUser().getId();
    }

    @Nonnull
    public String getCreatedDate() {
        return DateTimeConverter.convertTimestampToDateTime(this.pullRequestActivity.getCreatedDate().toInstant());
    }

    @Nonnull
    public String getActionName() {
        return this.pullRequestActivity.getAction().name();
    }

    @Nonnull
    public Map<String, Object> getAdditionalInformation() {
        if (this.pullRequestActivity instanceof PullRequestCommentActivity) {
            return this.extractFieldsForCommentActivity((PullRequestCommentActivity)this.pullRequestActivity);
        }
        if (this.pullRequestActivity instanceof PullRequestMergeActivity) {
            return this.extractFieldsForMergeActivity((PullRequestMergeActivity)this.pullRequestActivity);
        }
        return ImmutableMap.of();
    }

    private Map<String, Object> extractFieldsForCommentActivity(PullRequestCommentActivity commentActivity) {
        Comment comment = commentActivity.getComment();
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder().put((Object)"comment_id", (Object)comment.getId()).put((Object)"comment_action", (Object)commentActivity.getCommentAction().name()).put((Object)"author_id", (Object)comment.getAuthor().getId()).put((Object)"severity", (Object)comment.getSeverity().name()).put((Object)"state", (Object)comment.getState().name()).put((Object)"text", (Object)TextConverter.truncateText(comment.getText())).put((Object)"thread", (Object)comment.getThread().getId());
        if (comment.getResolvedDate() != null) {
            mapBuilder.put((Object)"resolved_date", (Object)DateTimeConverter.convertTimestampToDateTime(comment.getResolvedDate().toInstant()));
        }
        return mapBuilder.build();
    }

    private Map<String, Object> extractFieldsForMergeActivity(PullRequestMergeActivity mergeActivity) {
        return (Map)Optional.ofNullable(mergeActivity.getCommitId()).map(commitId -> ImmutableMap.of((Object)"commit_hash", (Object)commitId)).orElse(ImmutableMap.of());
    }
}

