/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.pullrequest;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestActivityPropertyMode;
import com.atlassian.bitbucket.pull.PullRequestActivitySearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class PullRequestActivityStreamer {
    public static final PullRequestActivityStreamer EMPTY_STREAMER = new PullRequestActivityStreamer(null){

        @Override
        public Stream<PullRequestActivity> stream(@Nonnull PullRequest pullRequest, @Nonnull Date fromDate) {
            return Stream.of(new PullRequestActivity[0]);
        }
    };
    private final PullRequestService pullRequestService;

    private PullRequestActivityStreamer(PullRequestService pullRequestService) {
        this.pullRequestService = pullRequestService;
    }

    public Stream<PullRequestActivity> stream(@Nonnull PullRequest pullRequest, @Nonnull Date fromDate) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(fromDate, "fromDate");
        Iterable iterableActivityPages = () -> new PullRequestActivityIterator(this.pullRequestService, pullRequest);
        return StreamSupport.stream(iterableActivityPages.spliterator(), false).flatMap(Collection::stream).filter(pullRequestActivity -> pullRequestActivity.getCreatedDate().getTime() >= fromDate.getTime());
    }

    @Nonnull
    public static PullRequestActivityStreamer getInstance(@Nonnull PullRequestService pullRequestService) {
        Objects.requireNonNull(pullRequestService, "pullRequestService");
        return new PullRequestActivityStreamer(pullRequestService);
    }

    private static class PullRequestActivityIterator
    extends AbstractIterator<List<PullRequestActivity>> {
        private static final int PAGE_SIZE = 1000;
        private final PullRequestService pullRequestService;
        private final PullRequestActivitySearchRequest pullRequestActivitySearchRequest;
        private PageRequest pageRequest;

        PullRequestActivityIterator(PullRequestService pullRequestService, PullRequest pullRequest) {
            this.pullRequestService = pullRequestService;
            this.pageRequest = new PageRequestImpl(0, 1000);
            this.pullRequestActivitySearchRequest = new PullRequestActivitySearchRequest.Builder(pullRequest).propertyMode(PullRequestActivityPropertyMode.NONE).build();
        }

        protected List<PullRequestActivity> computeNext() {
            if (this.pageRequest == null) {
                return (List)this.endOfData();
            }
            Page activityPage = this.pullRequestService.searchActivities(this.pullRequestActivitySearchRequest, this.pageRequest);
            if (activityPage.getSize() == 0) {
                return (List)this.endOfData();
            }
            this.pageRequest = activityPage.getNextPageRequest();
            return activityPage.stream().collect(Collectors.toList());
        }
    }
}

