/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.pullrequest;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PullRequestDetails {
    private final PullRequest pullRequest;
    private final List<PullRequestActivity> pullRequestActivities;
    private final long id;
    private final long commentsCount;
    private final long resolvedTasksCount;
    private final long tasksCount;
    private final Date updatedDate;

    public PullRequestDetails(@Nonnull PullRequest pullRequest, @Nonnull List<PullRequestActivity> pullRequestActivities, long commentsCount, long tasksCount, long resolvedTasksCount) {
        this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest must not be null");
        this.pullRequestActivities = Objects.requireNonNull(pullRequestActivities, "pull request activity list must not be null");
        this.id = pullRequest.getId();
        this.updatedDate = pullRequest.getUpdatedDate();
        this.commentsCount = commentsCount;
        this.tasksCount = tasksCount;
        this.resolvedTasksCount = resolvedTasksCount;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public List<PullRequestActivity> getPullRequestActivities() {
        return this.pullRequestActivities;
    }

    public long getCommentsCount() {
        return this.commentsCount;
    }

    public long getId() {
        return this.id;
    }

    public long getResolvedTasksCount() {
        return this.resolvedTasksCount;
    }

    public long getTasksCount() {
        return this.tasksCount;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return this.updatedDate;
    }
}

