/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.pullrequest;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestActivityDocument;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestDetails;
import com.atlassian.business.insights.core.util.DateTimeConverter;
import com.atlassian.business.insights.core.util.TextConverter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestDocument {
    private final PullRequestRef fromRef;
    private final ApplicationPropertiesService propertiesService;
    private final PullRequest pullRequest;
    private final List<PullRequestActivity> pullRequestActivities;
    private final PullRequestRef toRef;
    private final long commentsCount;
    private final long resolvedTasksCount;
    private final long tasksCount;

    public PullRequestDocument(@Nonnull ApplicationPropertiesService propertiesService, @Nonnull PullRequestDetails pullRequestDetails) {
        Objects.requireNonNull(propertiesService, "propertiesService must not be null");
        Objects.requireNonNull(pullRequestDetails, "pullRequestDetails must not be null");
        this.commentsCount = pullRequestDetails.getCommentsCount();
        this.resolvedTasksCount = pullRequestDetails.getResolvedTasksCount();
        this.tasksCount = pullRequestDetails.getTasksCount();
        this.propertiesService = propertiesService;
        this.pullRequest = pullRequestDetails.getPullRequest();
        this.pullRequestActivities = pullRequestDetails.getPullRequestActivities();
        this.fromRef = this.pullRequest.getFromRef();
        this.toRef = this.pullRequest.getToRef();
    }

    public long getApprovalsCount() {
        return this.pullRequest.getReviewers().stream().filter(participant -> participant.getStatus() == PullRequestParticipantStatus.APPROVED).count();
    }

    public int getAuthorId() {
        return this.pullRequest.getAuthor().getUser().getId();
    }

    @Nullable
    public String getClosedDate() {
        return this.pullRequest.getClosedDate() == null ? null : DateTimeConverter.convertTimestampToDateTime(this.pullRequest.getClosedDate().toInstant());
    }

    public long getCommentsCount() {
        return this.commentsCount;
    }

    @Nonnull
    public String getCreatedDate() {
        return DateTimeConverter.convertTimestampToDateTime(this.pullRequest.getCreatedDate().toInstant());
    }

    @Nonnull
    public String getFromBranchName() {
        return this.fromRef.getDisplayId();
    }

    @Nonnull
    public String getFromCommitHash() {
        return this.fromRef.getLatestCommit();
    }

    public int getFromRepositoryId() {
        return this.fromRef.getRepository().getId();
    }

    @Nonnull
    public String getId() {
        return this.getToRepositoryId() + "-" + this.getScopedId();
    }

    public long getScopedId() {
        return this.pullRequest.getId();
    }

    @Nullable
    public String getInstanceUrl() {
        return this.propertiesService.getBaseUrl() == null ? null : this.propertiesService.getBaseUrl().toString();
    }

    public int getParticipantCount() {
        return this.pullRequest.getParticipants().size();
    }

    @Nonnull
    public String getProjectKey() {
        return this.toRef.getRepository().getProject().getKey();
    }

    @Nonnull
    public String getRepoSlug() {
        return this.toRef.getRepository().getSlug();
    }

    public long getResolvedTasksCount() {
        return this.resolvedTasksCount;
    }

    public int getReviewerCount() {
        return this.pullRequest.getReviewers().size();
    }

    @Nonnull
    public String getState() {
        return this.pullRequest.getState().name();
    }

    public long getTasksCount() {
        return this.tasksCount;
    }

    @Nullable
    public Long getTimeToMerge() {
        if (this.pullRequest.getState() == PullRequestState.MERGED && this.pullRequest.getClosedDate() != null) {
            return this.pullRequest.getClosedDate().getTime() - this.pullRequest.getCreatedDate().getTime();
        }
        return null;
    }

    @Nonnull
    public String getTitle() {
        return this.pullRequest.getTitle();
    }

    @Nullable
    public String getDescription() {
        return TextConverter.truncateText(this.pullRequest.getDescription());
    }

    @Nonnull
    public String getToBranchName() {
        return this.toRef.getDisplayId();
    }

    @Nonnull
    public String getToCommitHash() {
        return this.toRef.getLatestCommit();
    }

    public int getToRepositoryId() {
        return this.toRef.getRepository().getId();
    }

    @Nonnull
    public String getUpdatedDate() {
        return DateTimeConverter.convertTimestampToDateTime(this.pullRequest.getUpdatedDate().toInstant());
    }

    @Nonnull
    public String getUrl() {
        return Optional.ofNullable(this.getInstanceUrl()).map(url -> url + "/projects/" + this.getProjectKey() + "/repos/" + this.getRepoSlug() + "/pull-requests/" + this.getScopedId()).orElse("");
    }

    @Nonnull
    public List<PullRequestActivityDocument> getPullRequestActivities() {
        String pullRequestId = this.getId();
        return this.pullRequestActivities.stream().map(activity -> new PullRequestActivityDocument((PullRequestActivity)activity, pullRequestId)).collect(Collectors.toList());
    }

    public int getVersion() {
        return this.pullRequest.getVersion();
    }
}

