/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.pullrequest;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.business.insights.api.Entity;
import com.atlassian.business.insights.api.extract.EntityStreamerQuery;
import com.atlassian.business.insights.bitbucket.extract.filter.BitbucketProjectOptOutFilter;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestActivityStreamer;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestDetails;
import com.google.common.collect.AbstractIterator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class PullRequestIterator
extends AbstractIterator<List<Entity<Long, PullRequestDetails>>> {
    public static final int PAGE_SIZE = 1000;
    private final PullRequestSearchRequest pullRequestSearchRequest;
    private final PullRequestService pullRequestService;
    private final Date fromDate;
    private final BitbucketProjectOptOutFilter bitbucketProjectOptOutFilter;
    private PageRequest pageRequest;
    private final PullRequestActivityStreamer activityStreamer;

    public PullRequestIterator(@Nonnull PullRequestService pullRequestService, @Nonnull EntityStreamerQuery entityStreamerQuery, @Nonnull PullRequestActivityStreamer pullRequestActivityStreamer) {
        this.pullRequestService = Objects.requireNonNull(pullRequestService, "pullRequestService");
        this.activityStreamer = Objects.requireNonNull(pullRequestActivityStreamer, "pullRequestActivityStreamer");
        Objects.requireNonNull(entityStreamerQuery, "entityStreamerQuery");
        this.fromDate = Date.from(entityStreamerQuery.getFrom());
        this.bitbucketProjectOptOutFilter = new BitbucketProjectOptOutFilter(entityStreamerQuery.getOptOutEntityIdentifiers());
        this.pullRequestSearchRequest = new PullRequestSearchRequest.Builder().updatedSince(this.fromDate).order(PullRequestOrder.OLDEST).build();
        this.pageRequest = new PageRequestImpl(0, 1000);
    }

    protected List<Entity<Long, PullRequestDetails>> computeNext() {
        if (this.pageRequest == null) {
            return (List)this.endOfData();
        }
        Page prPage = this.pullRequestService.search(this.pullRequestSearchRequest, this.pageRequest);
        if (prPage.getSize() == 0) {
            return (List)this.endOfData();
        }
        this.pageRequest = prPage.getNextPageRequest();
        return prPage.stream().filter(this::sourceOrDestinationNotInOptedOutProjects).map(this::getPullRequestDetails).map(prDetails -> Entity.getInstance(prDetails.getId(), prDetails.getUpdatedDate().toInstant(), prDetails)).collect(Collectors.toList());
    }

    private PullRequestDetails getPullRequestDetails(PullRequest pullRequest) {
        long commentsCount = this.getCommentCount(pullRequest);
        long resolvedTaskCount = this.getResolvedTaskCount(pullRequest);
        long totalTaskCount = resolvedTaskCount + this.getOpenTaskCount(pullRequest);
        List<PullRequestActivity> pullRequestActivities = this.getPullRequestActivities(pullRequest);
        return new PullRequestDetails(pullRequest, pullRequestActivities, commentsCount, totalTaskCount, resolvedTaskCount);
    }

    private List<PullRequestActivity> getPullRequestActivities(PullRequest pullRequest) {
        return this.activityStreamer.stream(pullRequest, this.fromDate).collect(Collectors.toList());
    }

    private long getCommentCount(PullRequest pullRequest) {
        return this.getPropertyValueOrDefaultZero(pullRequest, "commentCount");
    }

    private long getResolvedTaskCount(PullRequest pullRequest) {
        return this.getPropertyValueOrDefaultZero(pullRequest, "resolvedTaskCount");
    }

    private long getOpenTaskCount(PullRequest pullRequest) {
        return this.getPropertyValueOrDefaultZero(pullRequest, "openTaskCount");
    }

    private long getPropertyValueOrDefaultZero(PullRequest pullRequest, String property) {
        if (pullRequest.getProperties().containsKey((Object)property)) {
            return (Long)pullRequest.getProperties().get((Object)property);
        }
        return 0L;
    }

    private boolean sourceOrDestinationNotInOptedOutProjects(PullRequest pullRequest) {
        return this.bitbucketProjectOptOutFilter.test(pullRequest.getToRef().getRepository().getProject().getId()) && this.bitbucketProjectOptOutFilter.test(pullRequest.getFromRef().getRepository().getProject().getId());
    }
}

