/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.pullrequest;

import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.business.insights.api.Entity;
import com.atlassian.business.insights.api.extract.EntityStreamer;
import com.atlassian.business.insights.api.extract.EntityStreamerQuery;
import com.atlassian.business.insights.api.extract.StreamerValidationResult;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestActivityStreamer;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestDetails;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestIterator;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class PullRequestStreamer
implements EntityStreamer<Long, PullRequestDetails> {
    private final PullRequestService pullRequestService;
    private final PullRequestActivityStreamer pullRequestActivityStreamer;

    public PullRequestStreamer(@Nonnull PullRequestService pullRequestService, @Nonnull PullRequestActivityStreamer pullRequestActivityStreamer) {
        this.pullRequestService = Objects.requireNonNull(pullRequestService);
        this.pullRequestActivityStreamer = Objects.requireNonNull(pullRequestActivityStreamer);
    }

    @Override
    @Nonnull
    public StreamerValidationResult isReady() {
        return StreamerValidationResult.pass();
    }

    @Override
    public Stream<Entity<Long, PullRequestDetails>> stream(@Nonnull EntityStreamerQuery entityStreamerQuery) {
        Objects.requireNonNull(entityStreamerQuery, "entityStreamerQuery");
        Iterable prIterable = () -> new PullRequestIterator(this.pullRequestService, entityStreamerQuery, this.pullRequestActivityStreamer);
        return StreamSupport.stream(prIterable.spliterator(), false).flatMap(Collection::stream);
    }
}

