/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.pullrequest;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.business.insights.api.Entity;
import com.atlassian.business.insights.api.LogRecord;
import com.atlassian.business.insights.api.extract.EntityToLogRecordConverter;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestDetails;
import com.atlassian.business.insights.bitbucket.extract.pullrequest.PullRequestDocument;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.HashMap;
import java.util.Map;

public class PullRequestToLogRecordConverter
implements EntityToLogRecordConverter<Long, PullRequestDetails> {
    private static final TypeReference<HashMap<String, Object>> TYPE_REFERENCE = new TypeReference<HashMap<String, Object>>(){};
    private final ApplicationPropertiesService applicationPropertiesService;
    private final ObjectMapper objectMapper = new ObjectMapper().registerModules(new Module[]{new JavaTimeModule(), new Jdk8Module()});

    public PullRequestToLogRecordConverter(ApplicationPropertiesService propertiesService) {
        this.applicationPropertiesService = propertiesService;
    }

    @Override
    public LogRecord<Long> convert(Entity<Long, PullRequestDetails> entity) {
        Map<String, Object> payload = this.serialize(entity.getValue());
        return LogRecord.getInstance(entity.getId(), entity.getTimestamp(), payload);
    }

    private Map<String, Object> serialize(PullRequestDetails pullRequestDetails) {
        return (Map)this.objectMapper.convertValue((Object)new PullRequestDocument(this.applicationPropertiesService, pullRequestDetails), TYPE_REFERENCE);
    }
}

