/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.repository;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.business.insights.core.util.TextConverter;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryDocument {
    private final String instanceUrl;
    private final int repositoryId;
    private final String repositoryName;
    private final String description;
    private final boolean isForkable;
    private final boolean isFork;
    private final String hierarchyId;
    private final String originRepository;
    private final String projectName;
    private final boolean isPublic;
    private final String projectType;
    private final String slug;
    private final int projectId;
    private final String projectKey;
    private final boolean isOffline;
    private final boolean isLocal;
    private final boolean isArchived;
    private final boolean isReadOnly;

    public RepositoryDocument(@Nonnull ApplicationPropertiesService propertiesService, @Nonnull Repository repository) {
        Objects.requireNonNull(propertiesService, "propertiesService must not be null");
        Objects.requireNonNull(repository, "repository must not be null");
        this.instanceUrl = propertiesService.getBaseUrl() == null ? null : propertiesService.getBaseUrl().toString();
        this.repositoryId = repository.getId();
        this.repositoryName = repository.getName();
        this.description = repository.getDescription();
        this.isForkable = repository.isForkable();
        this.isFork = repository.isFork();
        this.hierarchyId = repository.getHierarchyId();
        this.projectName = repository.getProject().getName();
        this.isPublic = repository.isPublic();
        this.projectType = RepositoryDocument.uppercaseFirstLetterThenLowerCase(repository.getProject().getType().name());
        this.projectId = repository.getProject().getId();
        this.projectKey = repository.getProject().getKey();
        this.slug = repository.getSlug();
        this.originRepository = this.getOrigin(repository.getOrigin());
        this.isOffline = repository.isOffline();
        this.isLocal = repository.isLocal();
        this.isArchived = repository.isArchived();
        this.isReadOnly = repository.isReadOnly();
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    @Nullable
    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    @Nullable
    public String getUrl() {
        return Optional.ofNullable(this.getInstanceUrl()).map(url -> url + "/projects/" + this.projectKey + "/repos/" + this.slug).orElse("");
    }

    @Nonnull
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Nullable
    public String getDescription() {
        return TextConverter.truncateText(this.description);
    }

    @Nonnull
    public String getHierarchyId() {
        return this.hierarchyId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    @Nonnull
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nullable
    public String getOriginRepository() {
        return this.originRepository;
    }

    @Nonnull
    public String getProjectName() {
        return this.projectName;
    }

    public boolean getForkable() {
        return this.isForkable;
    }

    public boolean getFork() {
        return this.isFork;
    }

    public boolean getPublic() {
        return this.isPublic;
    }

    @Nonnull
    public String getProjectType() {
        return this.projectType;
    }

    public boolean getOffline() {
        return this.isOffline;
    }

    public boolean getLocal() {
        return this.isLocal;
    }

    public boolean getArchived() {
        return this.isArchived;
    }

    public boolean getReadOnly() {
        return this.isReadOnly;
    }

    @Nullable
    private String getOrigin(Repository origin) {
        return origin == null ? null : origin.getProject().getKey() + "/" + origin.getSlug();
    }

    @VisibleForTesting
    public static String uppercaseFirstLetterThenLowerCase(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1).toLowerCase();
    }
}

