/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.business.insights.api.Entity;
import com.google.common.collect.AbstractIterator;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public class RepositoryIterator
extends AbstractIterator<List<Entity<Integer, Repository>>> {
    public static final int REPOSITORY_PAGE_SIZE = 100;
    private final RepositoryService repositoryService;
    private PageRequest repositoryPageRequest;

    public RepositoryIterator(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
        this.repositoryPageRequest = new PageRequestImpl(0, 100);
    }

    protected List<Entity<Integer, Repository>> computeNext() {
        if (this.repositoryPageRequest == null) {
            return (List)this.endOfData();
        }
        Page repositoryPage = this.repositoryService.findAll(this.repositoryPageRequest);
        this.repositoryPageRequest = repositoryPage.getNextPageRequest();
        return repositoryPage.stream().map(repository -> Entity.getInstance(repository.getId(), Instant.EPOCH, repository)).collect(Collectors.toList());
    }
}

