/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.business.insights.api.Entity;
import com.atlassian.business.insights.api.extract.EntityStreamer;
import com.atlassian.business.insights.api.extract.EntityStreamerQuery;
import com.atlassian.business.insights.api.extract.StreamerValidationResult;
import com.atlassian.business.insights.bitbucket.extract.filter.BitbucketProjectOptOutFilter;
import com.atlassian.business.insights.bitbucket.extract.repository.RepositoryIterator;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class RepositoryStreamer
implements EntityStreamer<Integer, Repository> {
    private final RepositoryService repositoryService;

    public RepositoryStreamer(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    @Nonnull
    public StreamerValidationResult isReady() {
        return StreamerValidationResult.pass();
    }

    @Override
    public Stream<Entity<Integer, Repository>> stream(@Nonnull EntityStreamerQuery entityStreamerQuery) {
        Objects.requireNonNull(entityStreamerQuery, "entityStreamerQuery");
        BitbucketProjectOptOutFilter bitbucketProjectOptOutFilter = new BitbucketProjectOptOutFilter(entityStreamerQuery.getOptOutEntityIdentifiers());
        Iterable repositoryIterable = () -> new RepositoryIterator(this.repositoryService);
        return StreamSupport.stream(repositoryIterable.spliterator(), false).flatMap(Collection::stream).filter(repositoryEntity -> bitbucketProjectOptOutFilter.test(((Repository)repositoryEntity.getValue()).getProject().getId()));
    }
}

