/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.user;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserDocument {
    private final String instanceUrl;
    private final int id;
    private final String name;
    private final String fullName;
    private final String email;

    public UserDocument(@Nonnull ApplicationPropertiesService propertiesService, @Nonnull ApplicationUser user) {
        Objects.requireNonNull(propertiesService, "propertiesService must not be null");
        Objects.requireNonNull(user, "user must not be null");
        this.instanceUrl = propertiesService.getBaseUrl() == null ? null : propertiesService.getBaseUrl().toString();
        this.id = user.getId();
        this.name = user.getName();
        this.fullName = user.getDisplayName();
        this.email = user.getEmailAddress();
    }

    @Nullable
    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getFullName() {
        return this.fullName;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }
}

