/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.user;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.business.insights.api.Entity;
import com.google.common.collect.AbstractIterator;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class UserIterator
extends AbstractIterator<List<Entity<Integer, ApplicationUser>>> {
    public static final int USERS_PAGE_REQUEST = 100;
    private final UserService userService;
    private PageRequest usersPageRequest;

    public UserIterator(@Nonnull UserService userService) {
        this.userService = Objects.requireNonNull(userService);
        this.usersPageRequest = new PageRequestImpl(0, 100);
    }

    protected List<Entity<Integer, ApplicationUser>> computeNext() {
        if (this.usersPageRequest == null) {
            return (List)this.endOfData();
        }
        Page userPage = this.userService.findUsers(this.usersPageRequest);
        if (userPage.getSize() == 0) {
            return (List)this.endOfData();
        }
        this.usersPageRequest = userPage.getNextPageRequest();
        return userPage.stream().map(user -> Entity.getInstance(user.getId(), Instant.EPOCH, user)).collect(Collectors.toList());
    }
}

