/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.extract.user;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.business.insights.api.Entity;
import com.atlassian.business.insights.api.LogRecord;
import com.atlassian.business.insights.api.extract.EntityToLogRecordConverter;
import com.atlassian.business.insights.bitbucket.extract.user.UserDocument;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class UserToLogRecordConverter
implements EntityToLogRecordConverter<Integer, ApplicationUser> {
    private static final TypeReference<HashMap<String, Object>> TYPE_REFERENCE = new TypeReference<HashMap<String, Object>>(){};
    private final ObjectMapper objectMapper = new ObjectMapper().registerModules(new Module[]{new JavaTimeModule(), new Jdk8Module()});
    private final ApplicationPropertiesService applicationPropertiesService;

    public UserToLogRecordConverter(ApplicationPropertiesService applicationPropertiesService) {
        this.applicationPropertiesService = applicationPropertiesService;
    }

    @Override
    public LogRecord<Integer> convert(@Nonnull Entity<Integer, ApplicationUser> entity) {
        Map<String, Object> payload = this.serialize(entity.getValue());
        return LogRecord.getInstance(entity.getId(), entity.getTimestamp(), payload);
    }

    private Map<String, Object> serialize(@Nonnull ApplicationUser user) {
        return (Map)this.objectMapper.convertValue((Object)new UserDocument(this.applicationPropertiesService, user), TYPE_REFERENCE);
    }
}

