/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.schema;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.business.insights.api.schema.FileSchema;
import com.atlassian.business.insights.api.schema.Schema;
import com.atlassian.business.insights.attribute.AttributeDefinition;
import com.atlassian.business.insights.bitbucket.attribute.BuildAttributes;
import com.atlassian.business.insights.bitbucket.attribute.SharedAttributes;
import com.atlassian.business.insights.bitbucket.config.BitbucketPropertiesProvider;
import com.atlassian.business.insights.core.schema.ProductComputedFileSchema;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class BitbucketBuildStatusAwareSchemaV1
implements Schema {
    @VisibleForTesting
    public static final String BUILD_STATUSES_FILE_NAME = "build_statuses";
    private final ImmutableList<FileSchema> buildStatusAwareFileSchema;
    private final Schema delegate;
    private final BitbucketPropertiesProvider propertiesProvider;

    public BitbucketBuildStatusAwareSchemaV1(Schema delegate, BitbucketPropertiesProvider propertiesProvider) {
        this.delegate = delegate;
        this.propertiesProvider = propertiesProvider;
        this.buildStatusAwareFileSchema = this.constructBuildStatusAwareSchemas();
    }

    @Nonnull
    @VisibleForTesting
    static List<Map<String, Object>> getBuildStatusRows(List<AttributeDefinition> attributes, Map<String, Object> serializedEntity) {
        Object buildStatuses = serializedEntity.get("buildStatuses");
        if (!(buildStatuses instanceof List)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> buildStatusRows = new ArrayList<Map<String, Object>>();
        ((List)buildStatuses).forEach(uncastedBuildStatus -> {
            if (!(uncastedBuildStatus instanceof Map)) {
                return;
            }
            Map buildStatus = (Map)uncastedBuildStatus;
            HashMap row = new HashMap();
            for (AttributeDefinition attribute : attributes) {
                if (attribute.equals(SharedAttributes.COMMIT_ID) || attribute.equals(SharedAttributes.REPOSITORY_ID)) {
                    row.put(attribute.getExportName(), serializedEntity.get(attribute.getInternalName()));
                    continue;
                }
                row.put(attribute.getExportName(), buildStatus.get(attribute.getInternalName()));
            }
            buildStatusRows.add(Collections.unmodifiableMap(row));
        });
        return buildStatusRows;
    }

    private static FileSchema getBuildStatusFileSchema() {
        List<AttributeDefinition> attributes = BuildAttributes.getAttributes();
        return new ProductComputedFileSchema(BUILD_STATUSES_FILE_NAME, AttributeDefinition.toLinkedHashMap(attributes), serializedEntity -> BitbucketBuildStatusAwareSchemaV1.getBuildStatusRows(attributes, serializedEntity), () -> true);
    }

    @Override
    @Nonnull
    public String getDatasetName() {
        return this.delegate.getDatasetName();
    }

    @Override
    @Nonnull
    public List<FileSchema> getFileSchemas() {
        return this.buildStatusAwareFileSchema;
    }

    private ImmutableList<FileSchema> constructBuildStatusAwareSchemas() {
        ImmutableList.Builder enabledSchemas = new ImmutableList.Builder().addAll(this.delegate.getFileSchemas());
        if (this.propertiesProvider.isBuildStatusesExportEnabled()) {
            enabledSchemas.add((Object)BitbucketBuildStatusAwareSchemaV1.getBuildStatusFileSchema());
        }
        return enabledSchemas.build();
    }

    @Override
    public int getVersion() {
        return this.delegate.getVersion();
    }
}

