/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.schema;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.business.insights.attribute.AttributeDefinition;
import com.atlassian.business.insights.bitbucket.attribute.PullRequestActivitiesAttributes;
import com.atlassian.business.insights.core.schema.ColumnFileSchema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class BitbucketPullRequestActivitiesFileSchema
extends ColumnFileSchema {
    @VisibleForTesting
    public static final String PULL_REQUEST_ACTIVITIES_FILE_NAME = "pull_request_activities";
    @VisibleForTesting
    static final String ENTITY_ACTIVITIES_ATTRIBUTE = "pullRequestActivities";
    private final boolean isEnabled;

    public BitbucketPullRequestActivitiesFileSchema(boolean isEnabled) {
        super(PULL_REQUEST_ACTIVITIES_FILE_NAME, AttributeDefinition.toLinkedHashMap(PullRequestActivitiesAttributes.getAttributes()));
        this.isEnabled = isEnabled;
    }

    @Override
    @Nonnull
    public List<Map<String, Object>> computeEntries(@Nonnull Map<String, Object> serializedEntity) {
        Objects.requireNonNull(serializedEntity);
        Object pullRequestActivities = serializedEntity.get(ENTITY_ACTIVITIES_ATTRIBUTE);
        if (!(pullRequestActivities instanceof List)) {
            return Collections.emptyList();
        }
        return ((List)pullRequestActivities).stream().filter(activityObject -> activityObject instanceof Map).map(activityObject -> (Map)activityObject).flatMap(pullRequestActivity -> super.computeEntries((Map<String, Object>)pullRequestActivity).stream()).collect(Collectors.toList());
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BitbucketPullRequestActivitiesFileSchema that = (BitbucketPullRequestActivitiesFileSchema)o;
        return this.isEnabled == that.isEnabled;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isEnabled);
    }
}

