/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.spi;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.business.insights.api.filter.OptOutEntitiesLookupService;
import com.atlassian.business.insights.api.filter.OptOutEntitiesTransformationService;
import com.atlassian.business.insights.api.filter.OptOutEntity;
import com.atlassian.business.insights.api.filter.OptOutEntityIdentifier;
import com.atlassian.business.insights.api.filter.OptOutEntityType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class BitbucketOptOutEntitiesService
implements OptOutEntitiesLookupService,
OptOutEntitiesTransformationService {
    private final NavBuilder navBuilder;
    private final ProjectService projectService;

    public BitbucketOptOutEntitiesService(ProjectService projectService, NavBuilder navBuilder) {
        this.navBuilder = navBuilder;
        this.projectService = projectService;
    }

    @Override
    @Nonnull
    public Optional<OptOutEntity> lookupEntity(@Nonnull OptOutEntityType entityType, @Nonnull String entityKey) {
        Objects.requireNonNull(entityType, "entityType");
        Objects.requireNonNull(entityKey, "entityKey");
        if (entityType != OptOutEntityType.PROJECT) {
            return Optional.empty();
        }
        return this.getProjectByProjectKeyOrId(entityKey).map(project -> OptOutEntity.builder(OptOutEntityType.PROJECT, String.valueOf(project.getId())).displayName(project.getName()).key(project.getKey()).uri(this.projectUrl((Project)project)).build());
    }

    @Override
    @Nonnull
    public Set<OptOutEntityType> getSupportedEntityTypes() {
        return Collections.singleton(OptOutEntityType.PROJECT);
    }

    @Override
    @Nonnull
    public List<OptOutEntity> transform(@Nonnull List<OptOutEntityIdentifier> optOutEntityIdentifiers) {
        return optOutEntityIdentifiers.stream().filter(optOutResourceIdentifier -> OptOutEntityType.PROJECT == optOutResourceIdentifier.getType()).map(optOutResourceIdentifier -> this.getProjectById(optOutResourceIdentifier.getIdentifier()).map(project -> OptOutEntity.builder(OptOutEntityType.PROJECT, String.valueOf(project.getId())).displayName(project.getName()).key(project.getKey()).uri(this.projectUrl((Project)project)).build()).orElse(OptOutEntity.builder(optOutResourceIdentifier).build())).collect(Collectors.toList());
    }

    private String projectUrl(Project project) {
        return this.navBuilder.project(project).buildAbsolute();
    }

    private Optional<Project> getProjectByProjectKeyOrId(String identifier) {
        Optional<Project> project = Optional.ofNullable(this.projectService.getByKey(identifier));
        if (!project.isPresent()) {
            project = this.getProjectById(identifier);
        }
        return project;
    }

    private Optional<Project> getProjectById(String identifier) {
        if (StringUtils.isNumeric((CharSequence)identifier)) {
            return Optional.ofNullable(this.projectService.getById(Integer.parseInt(identifier)));
        }
        return Optional.empty();
    }
}

